/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core.os;

import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.ysb33r.grolifant.api.core.OperatingSystem;
import org.ysb33r.grolifant.internal.core.os.OperatingSystemConstants;

public class Windows
extends OperatingSystem {
    public static final OperatingSystem INSTANCE;
    private final String pathextVar;
    private final String pathVar;
    private final String sharedLibrarySuffix;
    private final String staticLibrarySuffix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected Windows() {
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        String string4;
        this.pathextVar = string4 = "PATHEXT";
        this.pathVar = string3 = "Path";
        this.sharedLibrarySuffix = string2 = ".dll";
        this.staticLibrarySuffix = string = ".lib";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public boolean isWindows() {
        return true;
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.withSuffix(executablePath, OperatingSystemConstants.DOT_EXE);
    }

    @Override
    public List<String> getExecutableNames(String executablePath) {
        List executableNames = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (this.extensionPos(executablePath) >= 0) {
            executableNames.add(executablePath);
        } else {
            String pathext = System.getenv(this.pathextVar);
            if (pathext != null && pathext.length() > 0) {
                String entry2 = null;
                String[] stringArray = pathext.split(Pattern.quote(this.getPathSeparator()));
                if (stringArray != null) {
                    for (String entry2 : stringArray) {
                        executableNames.add(this.withSuffix(executablePath, entry2));
                    }
                }
            } else {
                executableNames.add(this.withSuffix(executablePath, OperatingSystemConstants.DOT_EXE));
            }
        }
        return executableNames;
    }

    @Override
    public String getScriptName(String scriptPath) {
        return this.withSuffix(scriptPath, OperatingSystemConstants.DOT_BAT);
    }

    @Override
    public String getSharedLibraryName(String libraryName) {
        return this.withSuffix(libraryName, this.sharedLibrarySuffix);
    }

    @Override
    public String getStaticLibraryName(String libraryName) {
        return this.withSuffix(libraryName, this.staticLibrarySuffix);
    }

    @Override
    public OperatingSystem.Arch getArch() {
        String string = this.getArchStr();
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)OperatingSystemConstants.AMD64)) {
            return OperatingSystem.Arch.X86_64;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)OperatingSystemConstants.I386)) {
            return OperatingSystem.Arch.X86;
        }
        return OperatingSystem.Arch.UNKNOWN;
    }

    @Override
    public String getArchStr() {
        String string = OperatingSystem.OS_ARCH;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)OperatingSystemConstants.X86_64) || ScriptBytecodeAdapter.isCase((Object)string, (Object)OperatingSystemConstants.AMD64)) {
            return OperatingSystemConstants.AMD64;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)OperatingSystemConstants.X86)) {
            return OperatingSystemConstants.I386;
        }
        return OperatingSystemConstants.UNKNOWN;
    }

    private String withSuffix(String executablePath, String extension) {
        return ShortTypeHandling.castToString((Object)(executablePath.toLowerCase().endsWith(extension) ? executablePath : new GStringImpl(new Object[]{this.removeExtension(executablePath), extension}, new String[]{"", "", ""})));
    }

    private int extensionPos(String executablePath) {
        int fileNameStart = Math.max(executablePath.lastIndexOf("/"), executablePath.lastIndexOf("\\"));
        int extensionPos = executablePath.lastIndexOf(".");
        return extensionPos > fileNameStart ? Integer.valueOf(extensionPos) : Integer.valueOf(-1);
    }

    private String removeExtension(String executablePath) {
        int extensionPos = this.extensionPos(executablePath);
        return extensionPos >= 0 ? StringGroovyMethods.getAt((String)executablePath, (IntRange)new IntRange(true, 0, extensionPos)) : executablePath;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Windows.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Windows windows = new Windows();
        INSTANCE = windows;
    }

    @Generated
    public final String getPathextVar() {
        return this.pathextVar;
    }

    @Override
    @Generated
    public final String getSharedLibrarySuffix() {
        return this.sharedLibrarySuffix;
    }

    @Override
    @Generated
    public final String getStaticLibrarySuffix() {
        return this.staticLibrarySuffix;
    }
}

