/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core.runnable;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.core.executable.ExecutableEntryPoint;
import org.ysb33r.grolifant.api.core.runnable.AbstractExecSpec;

public abstract class AbstractExecWrapperTask<E extends AbstractExecSpec<E>>
extends DefaultTask {
    private final ProjectOperations projectOperations;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();
    private final Provider<Map<String, String>> envProvider;

    public void setEnvironment(Map<String, ?> args) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.setEnvironment(args)));
    }

    void addEnvironmentProvider(Provider<Map<String, String>> provider) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.addEnvironmentProvider(provider)));
    }

    public void environment(Map<String, ?> args) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.environment(args)));
    }

    @TaskAction
    protected void exec() {
        String exe = this.projectOperations.getStringTools().stringize(this.getExecutableLocation().get());
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.executable(exe)));
        ExecResult result = this.getProjectOperations().exec((Action<? super ExecSpec>)((Action)x -> ((AbstractExecSpec)this.getExecSpec()).copyTo((ExecSpec)x)));
        result.assertNormalExitValue();
    }

    protected AbstractExecWrapperTask() {
        this.projectOperations = ProjectOperations.find(this.getProject());
        this.envProvider = this.getProject().provider(() -> this.projectOperations.getStringTools().stringizeValues(this.env));
    }

    @Nested
    protected abstract E getExecSpec();

    @Internal
    protected abstract Provider<File> getExecutableLocation();

    @Internal
    protected ProjectOperations getProjectOperations() {
        return this.projectOperations;
    }
}

