/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core.jvm;

import org.gradle.api.Action;
import org.gradle.process.JavaExecSpec;
import org.ysb33r.grolifant.api.core.CmdlineArgumentSpec;
import org.ysb33r.grolifant.api.core.executable.ProcessExecutionSpec;

/**
 *
 * A specification to something that can be executed on the JVM and which be populated with various fork options
 * for Java and in addition, can then be used to copy to other methods in the Gradle API that provides a
 * {@link org.gradle.process.JavaForkOptions} in the parameters.
 *
 * @since 2.0
 */
public interface JvmAppRunnerSpec {
    /**
     * Copies these options to the given options.
     *
     * @param target The target options.
     * @return The options that were passed in.
     */
    JavaExecSpec copyTo(JavaExecSpec target);

    /**
     * Configures a {@link JavaForkOptionsWithEnvProvider} instance.
     * @param configurator Configurator.
     */
    void configureForkOptions(Action<JavaForkOptionsWithEnvProvider> configurator) ;

    /**
     * Configures a {@link CmdlineArgumentSpec} instance.
     * @param configurator Configurator.
     */
    void configureCmdline(Action<CmdlineArgumentSpec> configurator);

    /**
     * Configures a {@link JvmEntryPoint} instance.
     * @param configurator Configurator.
     */
    void configureEntrypoint(Action<JvmEntryPoint> configurator);

    /**
     * Configures a {@link ProcessExecutionSpec}.
     *
     * @param configurator  Configurator.
     */
    void configureProcess(Action<ProcessExecutionSpec> configurator);
}
