/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.core.runnable

import groovy.transform.CompileStatic
import org.gradle.process.BaseExecSpec
import org.ysb33r.grolifant.api.core.executable.ProcessExecutionSpec

@CompileStatic
class ProcessExecutionSpecProxy implements ProcessExecutionSpec {

    ProcessExecutionSpecProxy(BaseExecSpec instance) {
        this.delegate = instance
    }

    @Override
    InputStream getStandardInput() {
        delegate.standardInput
    }

    @Override
    OutputStream getStandardOutput() {
        delegate.standardOutput
    }

    @Override
    OutputStream getErrorOutput() {
        delegate.errorOutput
    }

    @Override
    boolean isIgnoreExitValue() {
        delegate.ignoreExitValue
    }

    @Override
    void setIgnoreExitValue(boolean iev) {
        delegate.ignoreExitValue = iev
    }

    @Override
    void setErrorOutput(OutputStream outputStream) {
        delegate.errorOutput = outputStream
    }

    @Override
    void setStandardInput(InputStream inputStream) {
        delegate.standardInput = inputStream
    }

    @Override
    void setStandardOutput(OutputStream outputStream) {
        delegate.standardOutput = outputStream
    }

    private final BaseExecSpec delegate
}
