/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core.executable;

import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant.api.core.CmdlineArgumentSpec;

import java.io.File;

/**
 * Describes how to configure a script and its arguments.
 *
 * @since 2.0
 */
public interface ScriptSpec extends CmdlineArgumentSpec {

    /**
     * Set the name of the script.
     *
     * This is useful for cases where the scripting system can auto-resolve the location of the script.
     *
     * @param lazyName Lazy evaluated name. Needs to evaluate to a string.
     */
    void setName(Object lazyName);

    /**
     * Sets the path of the script including the name of the script.
     *
     * Use this when the script is at a known location.
     *
     * @param lazyPath LAzy evaluated path on file system.
     */
    void setPath(Object lazyPath);

    /**
     * Provider to the name of a script.
     *
     * @return Script name provider. Can be empty.
     */
    Provider<String> getName();

    /**
     * Provider to the path of a script.
     *
     * @return Script file locaiton provider. Can be empty.
     */
    Provider<File> getPath();

    /**
     * Provider to either a script name or a string-based representation of the file path where the script can be
     * found.
     *
     * Normally the name should be resolved first, and if that is empty the path to the script.
     *
     * @return String-based resolver.
     */
    Provider<String> getNameOrPath();
}
