/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core.runnable;

import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.ysb33r.grolifant.api.core.CmdlineArgumentSpec;
import org.ysb33r.grolifant.api.core.executable.ProcessExecutionSpec;
import org.ysb33r.grolifant.api.core.executable.ExecutableEntryPoint;

/**
 * A process that can be executed outside the JVM.
 *
 * @param <T> Classes that extends {@code Executable}.
 *
 * @since 2.0
 */
public interface Executable<T extends Executable<T>> {

    /**
     * Configures the native entrypoint.
     *
     * @param configurator An action to configure the external executable's entrypoint.
     *
     * @return The configured executable
     */
    @Nested
    void entrypoint(Action<ExecutableEntryPoint> configurator);

    /**
     * Configures the arguments.
     *
     * @param configurator An action to configure the arguments.
     *
     * @return The configured executable
     */
    @Nested
    void runnerSpec(Action<CmdlineArgumentSpec> configurator);

    /**
     * Configures the stream redirections and exit checks.
     *
     * @param configurator An action to configure the execution.
     *
     * @return The configured executable.
     */
    @Nested
    void process(Action<ProcessExecutionSpec> configurator);
}
