/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core.runnable;

import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.ysb33r.grolifant.api.core.executable.ProcessExecutionSpec;
import org.ysb33r.grolifant.api.core.jvm.JavaForkOptionsWithEnvProvider;
import org.ysb33r.grolifant.api.core.jvm.JvmEntryPoint;
import org.ysb33r.grolifant.api.core.CmdlineArgumentSpec;

/**
 * A process that can be executed on a JVM
 * @param <T> Classes that extends {@code ForkedJvmExecutable}.
 *
 * @since 2.0
 */
public interface ForkedJvmExecutable<T extends ForkedJvmExecutable>  {
    /**
     * Configures a JVM that will be forked.
     *
     * @param configurator An action to configure the JVM's fork options.
     * @return The configured executable
     */
    @Nested
    T jvm(Action<JavaForkOptionsWithEnvProvider> configurator);

    /**
     * Configures the arguments.
     *
     * @param configurator An action to configure the arguments.
     *
     * @return The configured executable
     */
    @Nested
    T runnerSpec(Action<CmdlineArgumentSpec> configurator);

    /**
     * Configures the entrypoint for the JVM executable
     *
     * @param configurator An action to configure the entrypoint
     *
     * @return The configured executable.
     */
    @Nested
    T entrypoint(Action<JvmEntryPoint> configurator);

    /**
     * Configures the stream redirections and exit checks.
     *
     * @param configurator An action to configure the execution.
     *
     * @return The configured executable.
     */
    @Nested
    T process(Action<ProcessExecutionSpec> configurator);
}
