/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.loadable.core;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.TextResource;
import org.ysb33r.grolifant.api.core.StringTools;
import org.ysb33r.grolifant.api.errors.ChecksumCreationException;
import org.ysb33r.grolifant.internal.core.Transform;

public class StringToolsProxy
implements StringTools,
GroovyObject {
    private final ProviderFactory providers;
    private static final Closure URI_TRANSFORMER;
    private static final Function<Object, String> STRING_TRANSFORMER;
    private static final Function<Object, String> STRING_TRANSFORMER_NULL;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected StringToolsProxy(ProviderFactory pf) {
        ProviderFactory providerFactory;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.providers = providerFactory = pf;
    }

    @Override
    public String hashUri(URI uri) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA256");
        messageDigest.update(uri.toString().getBytes());
        String string = new BigInteger(1, messageDigest.digest()).toString(36);
        try {
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new ChecksumCreationException("Could not create SHA-256 checksum of URI", e);
        }
    }

    @Override
    public String packageNameFromUri(URI uri) {
        String path = uri.getPath();
        int p = path.lastIndexOf("/");
        return p < 0 ? path : path.substring(p + 1);
    }

    @Override
    public String stringize(Object stringy) {
        return ShortTypeHandling.castToString((Object)Transform.convertItem(stringy, STRING_TRANSFORMER));
    }

    @Override
    public String stringizeOrNull(Object stringy) {
        return ShortTypeHandling.castToString((Object)Transform.convertItemOrNull(stringy, STRING_TRANSFORMER_NULL));
    }

    @Override
    public List<String> stringize(Collection<?> stringyThings) {
        List output = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Transform.convertItems(stringyThings, output, STRING_TRANSFORMER);
        return output;
    }

    @Override
    public List<String> stringizeDropNull(Collection<?> stringyThings) {
        List output = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Transform.convertItemsDropNull(stringyThings, output, STRING_TRANSFORMER_NULL);
        return output;
    }

    @Override
    public URI safeUri(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    @Override
    public void updateStringProperty(Property<String> provider, Object stringy) {
        Reference stringy2 = new Reference(stringy);
        public final class _updateStringProperty_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stringy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateStringProperty_closure1(Object _outerInstance, Object _thisObject, Reference stringy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.stringy = reference = stringy;
            }

            public Object doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringizeOrNull(this.stringy.get());
            }

            @Generated
            public Object getStringy() {
                return this.stringy.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateStringProperty_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        provider.set(this.providers.provider((Callable)((Object)new _updateStringProperty_closure1(this, this, stringy2))));
    }

    @Override
    public URI urize(Object uriThingy) {
        return (URI)ScriptBytecodeAdapter.castToType(Transform.convertItem(uriThingy, (Function)ScriptBytecodeAdapter.castToType((Object)URI_TRANSFORMER.curry((Object)this), Function.class)), URI.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StringToolsProxy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Function function;
        Function function2;
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(StringTools str, Object uri) {
                Object object = uri;
                if (ScriptBytecodeAdapter.isCase((Object)object, URI.class)) {
                    return (URI)ScriptBytecodeAdapter.castToType((Object)uri, URI.class);
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, URL.class)) {
                    return ((URL)ScriptBytecodeAdapter.castToType((Object)uri, URL.class)).toURI();
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, File.class)) {
                    return ((File)ScriptBytecodeAdapter.castToType((Object)uri, File.class)).toURI();
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, Path.class)) {
                    return ((Path)ScriptBytecodeAdapter.castToType((Object)uri, Path.class)).toUri();
                }
                return ResourceGroovyMethods.toURI((String)str.stringize(uri));
            }

            public Object call(StringTools str, Object uri) {
                return this.doCall(str, uri);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        __clinit__closure2 __clinit__closure22 = new __clinit__closure2(StringToolsProxy.class, StringToolsProxy.class);
        URI_TRANSFORMER = __clinit__closure22;
        public final class __clinit__closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object str) {
                Object object = str;
                if (ScriptBytecodeAdapter.isCase((Object)object, TextResource.class)) {
                    return ((TextResource)ScriptBytecodeAdapter.castToType((Object)str, TextResource.class)).asString();
                }
                return DefaultGroovyMethods.toString((Object)str);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STRING_TRANSFORMER = function2 = (Function)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure3(StringToolsProxy.class, StringToolsProxy.class)), Function.class);
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object str) {
                return str == null ? null : STRING_TRANSFORMER.apply(str);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STRING_TRANSFORMER_NULL = function = (Function)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure4(StringToolsProxy.class, StringToolsProxy.class)), Function.class);
    }
}

