/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core.runnable;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkerExecutor;
import org.ysb33r.grolifant.api.core.CmdlineArgumentSpec;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.core.executable.ProcessExecutionSpec;
import org.ysb33r.grolifant.api.core.jvm.ExecutionMode;
import org.ysb33r.grolifant.api.core.jvm.JavaForkOptionsWithEnvProvider;
import org.ysb33r.grolifant.api.core.jvm.JvmEntryPoint;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerAppParameterFactory;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerPromise;
import org.ysb33r.grolifant.api.core.runnable.AbstractJvmExecSpec;
import org.ysb33r.grolifant.api.core.runnable.ForkedJvmExecutable;
import org.ysb33r.grolifant.api.core.runnable.JvmExecutionModel;
import org.ysb33r.grolifant.api.errors.UnsupportedConfigurationException;
import org.ysb33r.grolifant.api.remote.worker.SerializableWorkerAppParameters;
import org.ysb33r.grolifant.api.remote.worker.WorkerAppExecutorFactory;

public abstract class AbstractJvmModelExecTask<T extends AbstractJvmExecSpec, P extends SerializableWorkerAppParameters>
extends DefaultTask
implements ForkedJvmExecutable<T>,
JvmExecutionModel {
    private T execSpec;
    private ExecutionMode execMode;
    private Boolean awaitMode = false;
    private final ProjectOperations projectOperations = ProjectOperations.find(this.getProject());
    private final WorkerExecutor workerExecutor;
    private final Map<ExecutionMode, String> illegalExecutionModes;

    @Override
    public void setExecutionMode(ExecutionMode em) {
        if (this.illegalExecutionModes.containsKey((Object)em)) {
            throw new UnsupportedConfigurationException(em.name() + " cannot be used because: " + this.illegalExecutionModes.get((Object)em));
        }
        this.execMode = em;
    }

    @Override
    public void setAwaitMode(Boolean mode) {
        this.awaitMode = mode;
    }

    @Override
    public T jvm(Action<JavaForkOptionsWithEnvProvider> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).jvm((Action)configurator);
    }

    @Override
    public T runnerSpec(Action<CmdlineArgumentSpec> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).runnerSpec((Action)configurator);
    }

    @Override
    public T entrypoint(Action<JvmEntryPoint> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).entrypoint((Action)configurator);
    }

    @Override
    public T process(Action<ProcessExecutionSpec> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).process((Action)configurator);
    }

    protected AbstractJvmModelExecTask(@Nullable WorkerExecutor we) {
        this.execMode = ExecutionMode.JAVA_EXEC;
        this.workerExecutor = we;
        this.illegalExecutionModes = new TreeMap<ExecutionMode, String>();
    }

    protected abstract WorkerAppExecutorFactory<P> createExecutorFactory();

    protected abstract WorkerAppParameterFactory<P> createParameterFactory();

    @Nested
    protected T getJvmExecSpec() {
        return this.execSpec;
    }

    protected void setExecSpec(T execSpec) {
        this.execSpec = execSpec;
    }

    protected void preventExecutionMode(ExecutionMode mode, String reason) {
        this.illegalExecutionModes.put(mode, reason);
    }

    @Internal
    protected ProjectOperations getProjectOperations() {
        return this.projectOperations;
    }

    @TaskAction
    protected void exec() {
        if (this.execMode.equals((Object)ExecutionMode.JAVA_EXEC) || this.workerExecutor == null) {
            ExecResult result = this.projectOperations.javaexec((Action<? super JavaExecSpec>)((Action)x -> ((AbstractJvmExecSpec)this.getJvmExecSpec()).copyTo((JavaExecSpec)x)));
            result.assertNormalExitValue();
        } else {
            WorkerPromise promise = ((AbstractJvmExecSpec)this.getJvmExecSpec()).submitToWorkQueue(this.execMode.workerIsolation(), this.workerExecutor, this.createExecutorFactory(), this.createParameterFactory());
            if (this.awaitMode.equals(true)) {
                promise.await();
            }
        }
    }
}

