/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.core

import groovy.transform.CompileStatic
import org.gradle.api.model.ObjectFactory
import org.gradle.api.provider.Property
import org.gradle.api.provider.Provider
import org.gradle.api.provider.ProviderFactory
import org.ysb33r.grolifant.api.core.ProviderTools

/**
 * Common code code {@link ProviderTools}.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
@SuppressWarnings('AbstractClassWithoutAbstractMethod')
abstract class ProviderToolsProxy implements ProviderTools {
    protected ProviderToolsProxy(ProviderFactory providerFactory, ObjectFactory objectFactory) {
        this.providerFactory = providerFactory
        this.objectFactory = objectFactory
    }

    /**
     * Creates a {@link Property} instance
     *
     * @param valueType Class.
     * @return Property instance
     * @param <T>  Type of property
     *
     * @since 2.0
     */
    @Override
    public <T> Property<T> property(Class<T> valueType) {
        objectFactory.property(valueType)
    }

    /**
     * Creates a {@link Property} instance with a default value
     *
     * @param valueType Class.
     * @param defaultValue A provider that can provider this value.
     * @return Property instance
     * @param <T>  Type of property
     *
     * @since 2.0
     */
    @Override
    public <T> Property<T> property(Class<T> valueType, Provider<T> defaultValue) {
        final Property<T> prop = objectFactory.property(valueType)
        prop.set(defaultValue)
        prop
    }

    protected final ProviderFactory providerFactory
    protected final ObjectFactory objectFactory
}
