/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core.runnable;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.ysb33r.grolifant.api.core.ClosureUtils;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.core.executable.ScriptDefinition;
import org.ysb33r.grolifant.api.core.executable.ScriptSpec;
import org.ysb33r.grolifant.api.core.runnable.AbstractJvmExecSpec;
import org.ysb33r.grolifant.api.core.runnable.ForkedJvmScript;

public abstract class AbstractJvmScriptExecSpec<T extends AbstractJvmScriptExecSpec<T>>
extends AbstractJvmExecSpec<T>
implements ForkedJvmScript<T> {
    private final ScriptSpec jvmScript;
    private static final String SCRIPT_BLOCK = "script";

    @Override
    public T script(Action<ScriptSpec> configurator) {
        configurator.execute((Object)this.getScriptDefinition());
        return (T)this;
    }

    @Override
    public T script(@DelegatesTo(value=ScriptSpec.class) Closure<?> specConfigurator) {
        ClosureUtils.configureItem(this.getScriptDefinition(), specConfigurator);
        return (T)this;
    }

    protected AbstractJvmScriptExecSpec(ProjectOperations po) {
        super(po);
        this.jvmScript = new ScriptDefinition(po);
        this.getJvmForkOptions().addCommandLineProcessor(SCRIPT_BLOCK, 1, this.jvmScript);
    }

    @Nested
    protected ScriptSpec getScriptDefinition() {
        return this.jvmScript;
    }
}

