/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core;

import org.gradle.api.provider.Provider;

/**
 * A proxy class that can be used for seom methods that take an {@code Object} and then simply use {@code toString()}
 * on that object.
 *
 * @author Schalk W. Cronjé
 * @since 2.0
 */
public class ProviderToString {
    public static ProviderToString proxy(Provider<String> provider) {
        return new ProviderToString(provider);
    }

    @Override
    public String toString() {
        return provider.get();
    }

    private ProviderToString(Provider<String> provider) {
        this.provider = provider;
    }

    private final Provider<String> provider;
}
