/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core;

import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.ysb33r.grolifant.internal.core.loaders.RepositoryToolsLoader;

/**
 * Tools for working with repositories.
 *
 * @author Schalk W. Cronjé
 * @since 2.0
 */
public interface RepositoryTools {

    static RepositoryTools load(ProjectOperations incompleteReference, Project project) {
        return RepositoryToolsLoader.load(incompleteReference, project);
    }

    /**
     * Creates an instance of an {@link AuthenticationContainer}
     *
     * @return Authentication container that is usable with a repository.
     */
    AuthenticationContainer authenticationContainer();
}
