/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core.jvm.worker;

import org.ysb33r.grolifant.api.remote.worker.SerializableWorkerAppParameters;

/**
 * Creates a worker parameter POJO and optional configures it from execution specifications.
 *
 * @param <P> Parameter POJO or POGO.
 * @author Schalk W. Cronjé
 * @since 2.0
 */
public interface WorkerAppParameterFactory<P extends SerializableWorkerAppParameters> {
    /**
     * @param execSpec Java execution specification that can be used for setting worker execution details.
     * @return A parameter configuration.
     */
    P createAndConfigure(WorkerExecSpec execSpec);
}
