/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.core;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.ysb33r.grolifant.api.core.os.FreeBSD;
import org.ysb33r.grolifant.api.core.os.GenericUnix;
import org.ysb33r.grolifant.api.core.os.Linux;
import org.ysb33r.grolifant.api.core.os.MacOsX;
import org.ysb33r.grolifant.api.core.os.NetBSD;
import org.ysb33r.grolifant.api.core.os.Solaris;
import org.ysb33r.grolifant.api.core.os.Windows;
import org.ysb33r.grolifant.internal.core.os.OperatingSystemConstants;

public abstract class OperatingSystem
implements GroovyObject {
    private final String name;
    private final String version;
    private final String pathVar;
    protected static final String OS_NAME;
    protected static final String OS_ARCH;
    protected static final String OS_VERSION;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected OperatingSystem() {
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        this.name = string3 = OS_NAME;
        this.version = string2 = OS_VERSION;
        this.pathVar = string = "PATH";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isMacOsX() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public boolean isFreeBSD() {
        return false;
    }

    public boolean isNetBSD() {
        return false;
    }

    public boolean isSolaris() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public String getPathSeparator() {
        return File.pathSeparator;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        String string = this.name;
        objectArray[0] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
        String string2 = this.version;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
        Arch arch = this.getArch();
        objectArray[2] = DefaultTypeTransformation.booleanUnbox((Object)((Object)arch)) ? arch : "";
        return ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"", " ", " ", ""}));
    }

    public File findInPath(String name) {
        String exeName = null;
        Iterator<String> iterator = this.getExecutableNames(name).iterator();
        while (iterator.hasNext()) {
            exeName = ShortTypeHandling.castToString((Object)iterator.next());
            if (exeName.contains(this.getPathSeparator())) {
                File candidate = new File(exeName);
                if (!candidate.isFile()) continue;
                return candidate;
            }
            File dir = null;
            Iterator<File> iterator2 = this.getPath().iterator();
            while (iterator2.hasNext()) {
                dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), File.class);
                File candidate = new File(dir, exeName);
                if (!candidate.isFile()) continue;
                return candidate;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public List<File> getPath() {
        List entries = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String path = System.getenv(this.pathVar);
        if (path != null) {
            String entry2 = null;
            String[] stringArray = path.split(Pattern.quote(this.getPathSeparator()));
            if (stringArray != null) {
                for (String entry2 : stringArray) {
                    entries.add(new File(entry2));
                }
            }
        }
        return entries;
    }

    public List<File> findAllInPath(String name) {
        List all = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        File dir = null;
        Iterator<File> iterator = this.getPath().iterator();
        while (iterator.hasNext()) {
            dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
            File candidate = new File(dir, name);
            if (!candidate.isFile()) continue;
            all.add(candidate);
        }
        return all;
    }

    @Deprecated
    public abstract String getExecutableName(String var1);

    public abstract List<String> getExecutableNames(String var1);

    public abstract Arch getArch();

    public abstract String getArchStr();

    public abstract String getSharedLibrarySuffix();

    public abstract String getStaticLibrarySuffix();

    @Deprecated
    public abstract String getScriptName(String var1);

    public abstract String getSharedLibraryName(String var1);

    public abstract String getStaticLibraryName(String var1);

    public static OperatingSystem current() {
        if (OS_NAME.contains("windows")) {
            return Windows.INSTANCE;
        }
        if (OS_NAME.contains("mac os x") || OS_NAME.contains("darwin") || OS_NAME.contains("osx")) {
            return MacOsX.getINSTANCE();
        }
        if (OS_NAME.contains("linux")) {
            return Linux.getINSTANCE();
        }
        if (OS_NAME.contains("freebsd")) {
            return FreeBSD.getINSTANCE();
        }
        if (OS_NAME.contains("sunos") || OS_NAME.contains("solaris")) {
            return Solaris.getINSTANCE();
        }
        if (OS_NAME.contains("netbsd")) {
            return NetBSD.getINSTANCE();
        }
        return GenericUnix.getINSTANCE();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OperatingSystem.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OperatingSystem.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        String string3;
        OS_NAME = string3 = System.getProperty("os.name").toLowerCase();
        OS_ARCH = string2 = System.getProperty("os.arch").toLowerCase();
        OS_VERSION = string = System.getProperty("os.version").toLowerCase();
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final String getVersion() {
        return this.version;
    }

    @Generated
    public final String getPathVar() {
        return this.pathVar;
    }

    public static final class Arch
    extends Enum<Arch>
    implements GroovyObject {
        public static final /* enum */ Arch X86_64;
        public static final /* enum */ Arch X86;
        public static final /* enum */ Arch POWERPC;
        public static final /* enum */ Arch SPARC;
        public static final /* enum */ Arch ARM64;
        public static final /* enum */ Arch ARM32;
        public static final /* enum */ Arch S390_32;
        public static final /* enum */ Arch S390_64;
        public static final /* enum */ Arch UNKNOWN;
        private final String id;
        public static final Arch MIN_VALUE;
        public static final Arch MAX_VALUE;
        private static final /* synthetic */ Arch[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        private Arch(String id) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = id;
        }

        public static final Arch[] values() {
            return (Arch[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Arch[].class);
        }

        public /* synthetic */ Arch next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Arch)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Arch.class);
        }

        public /* synthetic */ Arch previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Arch)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Arch.class);
        }

        public static Arch valueOf(String name) {
            return (Arch)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Arch.class, name)), Arch.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ Arch $INIT(Object ... para) {
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Arch.class)) {
                case -613992018: {
                    return new Arch(ShortTypeHandling.castToString((Object)objectArray[2]));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            Arch arch;
            Arch arch2;
            Arch arch3;
            Arch arch4;
            Arch arch5;
            Arch arch6;
            Arch arch7;
            Arch arch8;
            Arch arch9;
            Arch arch10;
            Arch arch11;
            X86_64 = arch11 = Arch.$INIT("X86_64", 0, OperatingSystemConstants.AMD64);
            X86 = arch10 = Arch.$INIT("X86", 1, OperatingSystemConstants.I386);
            POWERPC = arch9 = Arch.$INIT("POWERPC", 2, "ppc");
            SPARC = arch8 = Arch.$INIT("SPARC", 3, "sparc");
            ARM64 = arch7 = Arch.$INIT("ARM64", 4, OperatingSystemConstants.AARCH64);
            ARM32 = arch6 = Arch.$INIT("ARM32", 5, OperatingSystemConstants.AARCH32);
            S390_32 = arch5 = Arch.$INIT("S390_32", 6, "s390_32");
            S390_64 = arch4 = Arch.$INIT("S390_64", 7, "s390_64");
            UNKNOWN = arch3 = Arch.$INIT("UNKNOWN", 8, "(unknown)");
            MIN_VALUE = arch2 = X86_64;
            MAX_VALUE = arch = UNKNOWN;
            Arch[] archArray = new Arch[]{X86_64, X86, POWERPC, SPARC, ARM64, ARM32, S390_32, S390_64, UNKNOWN};
            $VALUES = archArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Arch.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

