/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.core;

import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant.internal.core.loaders.ProjectToolsLoader;

import java.util.Collection;

/**
 * Provides various project-related information.
 *
 * @author Schalk W. Cronjé
 * @since 2.0
 */
public interface ProjectTools {

    /**
     * Lazy-evaluated project version.
     *
     * @return Provider to project version
     */
    Provider<String> getVersionProvider();

    /**
     * Lazy-evaluated project group.
     *
     * @return provider to project group
     */
    Provider<String> getGroupProvider();

    /**
     * Resolves an arbitrary item to a {@link Configuration} instance.
     *
     * @param configurationThingy Instance or {@link Configuration} or something that resolves to a string.
     * @return Configuration
     * @deprecated Use {@link ConfigurationTools#asConfiguration(Object)} instead.
     */
    @Deprecated
    Configuration asConfiguration(Object configurationThingy);

    /**
     * Resolves arbitrary items to a collection of {@link Configuration} instances.
     * @param configurationThingies Collection that might contain {@link Configuration} or string-type instances
     * @return Collection of resolved {@link Configuration} instances
     * @deprecated Use {@link ConfigurationTools#asConfigurations(Collection)} instead.
     */
    @Deprecated
    Collection<Configuration> asConfigurations(Collection<?> configurationThingies);

    /**
     * Sets a new version for a project.
     * <p>This creates an internal objhect that can safely be evaluated by
     * Gradle's {@link org.gradle.api.Project#getVersion}.
     * </p>
     *
     * @param newVersion Anything that can be converted to a string using
     *    {@link org.ysb33r.grolifant.api.core.StringTools}.
     */
    void setVersionProvider(Object newVersion);
}
