/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.errors

import groovy.transform.CompileStatic

/** Thrown when a type instance cannot be converted to a Gradle-specific type instance.
 *
 * @author Schalk W. Cronje
 *
 * @since 0.17.0
 */
@CompileStatic
class UnsupportedConfigurationException extends RuntimeException implements GrolifantError {
    UnsupportedConfigurationException(final String message) {
        super(message)
    }

    UnsupportedConfigurationException(final String message, final Exception e) {
        super(message, e)
    }

    UnsupportedConfigurationException(final String message, final Throwable e) {
        super(message, e)
    }
}
