/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.v4.runnable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.v4.StringUtils;
import org.ysb33r.grolifant.api.v4.runnable.AbstractExecSpec;
import org.ysb33r.grolifant.api.v4.runnable.ExecutableCommandExecSpec;

public abstract class AbstractExecCommandSpec<T extends AbstractExecSpec<T>>
extends AbstractExecSpec<T>
implements ExecutableCommandExecSpec<T> {
    private final List<Object> cmdArgs = new ArrayList<Object>();
    private final Provider<List<String>> cmdArgsProvider;
    private final Provider<String> commandProvider = this.getProjectOperations().provider(() -> StringUtils.stringize(this.cmd));
    private Object cmd;

    @Override
    public Provider<String> getCommand() {
        return this.commandProvider;
    }

    @Override
    public T setCommand(Object cmd) {
        this.cmd = cmd;
        return (T)this;
    }

    @Override
    public T setCmdArgs(Iterable<?> args) {
        this.cmdArgs.clear();
        for (Object i : args) {
            this.cmdArgs.add(i);
        }
        return (T)this;
    }

    @Override
    public void cmdArgs(Iterable<?> args) {
        for (Object i : args) {
            this.cmdArgs.add(i);
        }
    }

    @Override
    public void cmdArgs(Object ... args) {
        for (Object i : args) {
            this.cmdArgs.add(i);
        }
    }

    @Override
    public Provider<List<String>> getCmdArgs() {
        return this.cmdArgsProvider;
    }

    protected AbstractExecCommandSpec(ProjectOperations projectOperations) {
        super(projectOperations);
        this.cmdArgsProvider = this.getProjectOperations().provider(() -> StringUtils.stringize(this.cmdArgs));
    }

    @Override
    protected List<String> buildCommandLine() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getExecutable());
        args.addAll((Collection)this.getExeArgs().get());
        args.add((String)this.getCommand().get());
        args.addAll((Collection)this.getCmdArgs().get());
        return args;
    }
}

