/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.v4.runnable;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.v4.MapUtils;
import org.ysb33r.grolifant.api.v4.StringUtils;
import org.ysb33r.grolifant.api.v4.runnable.CopyExecSpec;
import org.ysb33r.grolifant.api.v4.runnable.ExecutableExecSpec;

public abstract class AbstractExecSpec<T extends ExecutableExecSpec<T>>
implements ExecutableExecSpec<T>,
CopyExecSpec {
    private final ProjectOperations projectOperations;
    private final List<Object> exeArgs = new ArrayList<Object>();
    private final Map<String, Object> env = new TreeMap<String, Object>();
    private final List<Provider<Map<String, String>>> envVarProviders = new ArrayList<Provider<Map<String, String>>>();
    private final Provider<List<String>> exeArgsProvider;
    private final Provider<List<String>> commandLineProvider;
    private final Provider<Map<String, String>> environmentProvider;
    private final Provider<String> executableProvider;
    private final Provider<File> workingDirProvider;
    private InputStream stdin;
    private OutputStream stdout;
    private OutputStream stderr;
    private Object exe;
    private Object wd;
    private boolean ignoreExit = false;

    @Override
    public void addEnvironmentProvider(Provider<Map<String, String>> envProvider) {
        this.envVarProviders.add(envProvider);
    }

    @Override
    public T exeArgs(Iterable<?> args) {
        for (Object i : args) {
            this.exeArgs.add(i);
        }
        return (T)this;
    }

    @Override
    public T exeArgs(Object ... args) {
        for (Object i : args) {
            this.exeArgs.add(i);
        }
        return (T)this;
    }

    @Override
    public T copyTo(ProcessForkOptions target) {
        target.setEnvironment(this.getEnvironment());
        target.setExecutable(this.getExecutable());
        target.setWorkingDir(this.getWorkingDir());
        return (T)this;
    }

    @Override
    public T environment(String name, Object value) {
        this.env.put(name, value);
        return (T)this;
    }

    @Override
    public T environment(Map<String, ?> environmentVariables) {
        this.env.putAll(environmentVariables);
        return (T)this;
    }

    @Override
    public T executable(Object executable) {
        this.exe = executable;
        return (T)this;
    }

    @Override
    @Input
    public Provider<List<String>> getExeArgs() {
        return this.exeArgsProvider;
    }

    @Override
    @Internal
    public Provider<List<String>> getCommandLineProvider() {
        return this.commandLineProvider;
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.env;
    }

    @Override
    @Input
    public Provider<Map<String, String>> getEnvironmentProvider() {
        return this.environmentProvider;
    }

    @Override
    @Internal
    public OutputStream getErrorOutput() {
        return this.stderr;
    }

    @Override
    @Input
    public Provider<String> getExecutableProvider() {
        return this.executableProvider;
    }

    @Override
    @Internal
    public InputStream getStandardInput() {
        return this.stdin;
    }

    @Override
    @Internal
    public OutputStream getStandardOutput() {
        return this.stdout;
    }

    @Override
    @InputFile
    public Provider<File> getWorkingDirProvider() {
        return this.workingDirProvider;
    }

    @Override
    @Internal
    public boolean isIgnoreExitValue() {
        return this.ignoreExit;
    }

    @Override
    public T setExeArgs(Iterable<?> arguments) {
        this.exeArgs.clear();
        for (Object i : arguments) {
            this.exeArgs.add(i);
        }
        return (T)this;
    }

    @Override
    public T setExeArgs(List<String> arguments) {
        this.exeArgs.clear();
        for (String i : arguments) {
            this.exeArgs.add(i);
        }
        return (T)this;
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.env.clear();
        this.env.putAll(environmentVariables);
    }

    @Override
    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.stderr = outputStream;
        return this;
    }

    @Override
    public void setExecutable(Object executable) {
        this.exe = executable;
    }

    @Override
    public BaseExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExit = ignoreExitValue;
        return this;
    }

    @Override
    public BaseExecSpec setStandardInput(InputStream inputStream) {
        this.stdin = inputStream;
        return this;
    }

    @Override
    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        this.stdout = outputStream;
        return this;
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.wd = dir;
    }

    public void setExecutable(String s) {
        this.exe = s;
    }

    public void setWorkingDir(File file) {
        this.wd = file;
    }

    public ProcessForkOptions workingDir(Object o) {
        this.wd = o;
        return this;
    }

    @Override
    public void copyToExecSpec(ExecSpec execSpec) {
        this.copyTo((ProcessForkOptions)execSpec);
        execSpec.setCommandLine(this.buildCommandLine());
        execSpec.setErrorOutput(this.getErrorOutput());
        execSpec.setStandardInput(this.getStandardInput());
        execSpec.setStandardOutput(this.getStandardOutput());
        execSpec.setIgnoreExitValue(this.isIgnoreExitValue());
    }

    protected AbstractExecSpec(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
        this.exeArgsProvider = projectOperations.provider(() -> StringUtils.stringize(this.exeArgs));
        this.commandLineProvider = projectOperations.provider(() -> this.buildCommandLine());
        this.executableProvider = projectOperations.provider(() -> StringUtils.stringize(this.exe));
        this.workingDirProvider = projectOperations.provider(() -> projectOperations.file(this.wd));
        this.stdin = System.in;
        this.stdout = System.out;
        this.stderr = System.err;
        this.wd = projectOperations.getProjectDir();
        this.environmentProvider = projectOperations.provider(() -> {
            TreeMap<String, String> finalEnv = new TreeMap<String, String>();
            this.envVarProviders.forEach(p -> finalEnv.putAll((Map)p.get()));
            finalEnv.putAll(MapUtils.stringizeValues(this.env));
            return finalEnv;
        });
    }

    protected ProjectOperations getProjectOperations() {
        return this.projectOperations;
    }

    protected List<String> buildCommandLine() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getExecutable());
        args.addAll((Collection)this.getExeArgs().get());
        return null;
    }
}

