/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2021
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v4.wrappers

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.provider.Property
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.api.core.ProjectOperations

/**
 * Wraps a Gradle Property.
 *
 * @since 1.3
 */
@CompileStatic
class FileProperty implements FilePropertyWrapper {
    FileProperty(Project project) {
        this.prop = project.objects.property(File)
        this.projectOperations = ProjectOperations.find(project)
    }

    /**
     * Gets the file referenced by this property.
     *
     * @return File instance.
     */
    @Override
    File getFile() {
        this.prop.get()
    }

    /**
     * Gets the provider for this file property
     *
     * @return File provider
     */
    @Override
    Provider<File> getFileProvider() {
        this.prop
    }

    /**
     * Sets a lazy-evaluated file.
     *
     * @param file
     */
    @Override
    void setFile(Object file) {
        projectOperations.updateFileProperty(this.prop, file)
    }

    private final Property<File> prop
    private final ProjectOperations projectOperations
}
