/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v4.executable

import groovy.transform.CompileStatic
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.api.core.executable.CommandEntryPoint
import org.ysb33r.grolifant.api.core.runnable.AbstractCmdlineArgumentSpec

import java.util.concurrent.Callable

/**
 * Command-ine argument handler for a command.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class Pre43CommandArgumentSpec extends AbstractCmdlineArgumentSpec implements CommandEntryPoint {

    Pre43CommandArgumentSpec(ProjectOperations po) {
        super(po)
        cmd = []
        cmdProvider = po.providers.provider({ List<Object> val ->
            val.empty ? null : po.stringTools.stringizeOrNull(val[0])
        }.curry(this.cmd) as Callable<String>)
        this.preArgsProvider = po.providers.provider({ List<Object> val ->
            po.stringTools.stringizeDropNull(val)
        }.curry(this.cmd) as Callable<List<String>>)
    }

    /**
     * Set the lazy-evaluated command.
     *
     * @param name Name of command. Must evaluate to a string.
     */
    @Override
    void setCommand(Object name) {
        this.cmd[0] = name
    }

    /**
     * Get the command.
     *
     * @return A provider to the command.
     */
    @Override
    Provider<String> getCommand() {
        this.cmdProvider
    }

    /**
     * All defined arguments, plus all arguments providers via the command-line argument providers.
     *
     * @return Provider to a fully-resolved set of arguments.
     */
    @Override
    Provider<List<String>> getAllArgs() {
        super.allArgs
    }

    /**
     * A provider to arguments that will be inserted before any supplied arguments.
     *
     * @return Arguments provider
     */
    @Override
    Provider<List<String>> getPreArgs() {
        this.preArgsProvider
    }

    private final Provider<String> cmdProvider
    private final List<Object> cmd
    private final Provider<List<String>> preArgsProvider
}
