/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2022
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v4

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.process.JavaExecSpec
import org.ysb33r.grolifant.api.core.JvmTools
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.api.core.jvm.JvmAppRunnerSpec
import org.ysb33r.grolifant.api.errors.NotSupportedException
import org.ysb33r.grolifant.internal.v4.jvm.InternalJvmAppRunnerSpec
import org.ysb33r.grolifant.internal.v4.jvm.Pre46FakeJavaExecSpec
import org.ysb33r.grolifant.internal.v4.jvm.Pre56FakeJavaExecSpec

import static org.ysb33r.grolifant.api.core.LegacyLevel.PRE_4_6
import static org.ysb33r.grolifant.api.core.LegacyLevel.PRE_5_6

@CompileStatic
class DefaultJvmTools implements JvmTools {

    @SuppressWarnings('UnusedMethodParameter')
    DefaultJvmTools(
        ProjectOperations projectOperationsIncomplete,
        Project tempProjectReference
    ) {
        this.projectOperations = projectOperationsIncomplete
    }

    /**
     * Creates a {@link JavaExecSpec}.
     *
     * @return Returns something compatible with a {@link JavaExecSpec}.
     */
    @Override
    JavaExecSpec javaExecSpec() {
        if (PRE_4_6) {
            new Pre46FakeJavaExecSpec(projectOperations) as JavaExecSpec
        } else if (PRE_5_6) {
            new Pre56FakeJavaExecSpec(projectOperations) as JavaExecSpec
        } else {
            NotSupportedException.needsSpecificGrolifantLibrary('JVM-based execution')
        }
    }

    /**
     * Creates a {@link JvmAppRunnerSpec}.
     *
     * THis is primarly used internally by classes that implements execution specifications on the JVM.
     *
     * @return Implmentation of {@link JvmAppRunnerSpec}
     */
    @Override
    JvmAppRunnerSpec jvmAppRunnerSpec() {
        new InternalJvmAppRunnerSpec(projectOperations)
    }

    private final ProjectOperations projectOperations
}
