/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v4.jvm

import groovy.transform.CompileDynamic
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.internal.core.runnable.EnvironmentVariableProviders

/**
 * THis is a workaround for Gradle <4.6 becasue the {@code org.gradle.process.CommandLineArgumentProvider} does not
 * exist on these Gradle versions, but we compile {@code grolifant40} with a later version of Gradle 4.x
 *
 * This class works around the dreaded {@ode ClassNotFoundException}.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileDynamic
class Pre46JavaForkOptionsWithEnvProviderProxy {

    Pre46JavaForkOptionsWithEnvProviderProxy(
        Object instance,
        EnvironmentVariableProviders evp
    ) {
        this.delegate = instance
        this.evp = evp
    }

    @SuppressWarnings('MethodParameterTypeRequired')
    Object methodMissing(String name, args) {
        switch (name) {
            case 'executable':
                delegate.executable((Object) args[0])
                break
            default:
                delegate.invokeMethod(name, args)
        }
    }

    void addEnvironmentProvider(Provider<Map<String, String>> envProvider) {
        evp.addEnvironmentProvider(envProvider)
    }

    private final Object delegate
    private final EnvironmentVariableProviders evp
}
