/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v4.executable

import groovy.transform.CompileStatic
import org.gradle.process.CommandLineArgumentProvider
import org.gradle.process.ExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations

/**
 *
 * Fakes an {@link ExecSpec} on Gradle 4.6 - Gradle 6.5.1.
 *
 * @author Schalk W> Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class Pre66FakeExecSpec extends Pre46FakeExecSpec implements ExecSpec {

    Pre66FakeExecSpec(ProjectOperations po) {
        super(po)
    }

    /**
     * Argument providers for the application on Gradle 4.6+
     *
     * @return Access to the list of argument providers.
     */
    @Override
    List<CommandLineArgumentProvider> getArgumentProviders() {
        argsProviderList
    }

    @Override
    protected ExecSpec me() {
        (ExecSpec) this
    }

    private final List<CommandLineArgumentProvider> argsProviderList = []
}
