/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v4.jvm

import groovy.transform.CompileStatic
import groovy.util.logging.Slf4j
import org.gradle.api.Action
import org.gradle.api.provider.Provider
import org.gradle.process.JavaForkOptions
import org.gradle.util.GradleVersion
import org.ysb33r.grolifant.api.core.jvm.JavaForkOptionsWithEnvProvider
import org.ysb33r.grolifant.api.core.jvm.JvmDebugOptions
import org.ysb33r.grolifant.internal.core.runnable.EnvironmentVariableProviders

@CompileStatic
@Slf4j
class Pre56JavaForkOptionsWithEnvProviderProxy implements JavaForkOptionsWithEnvProvider {

    Pre56JavaForkOptionsWithEnvProviderProxy(
        JavaForkOptions instance,
        EnvironmentVariableProviders evp
    ) {
        this.delegate = instance
        this.evp = evp
    }

    void addEnvironmentProvider(Provider<Map<String, String>> envProvider) {
        evp.addEnvironmentProvider(envProvider)
    }

    @Override
    void withDebug(Action<JvmDebugOptions> configurator) {
        log.info "Setting debug options is ignored on ${GradleVersion.current().version}"
    }

    @Delegate(interfaces = true, deprecated = true, methodAnnotations = true, parameterAnnotations = true)
    private final JavaForkOptions delegate

    private final EnvironmentVariableProviders evp
}
