/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.internal.v8.executable

import groovy.transform.CompileStatic
import org.gradle.process.ProcessForkOptions
import org.ysb33r.grolifant5.api.core.GrolifantProcessForkOptions

/**
 * Proxies a {@link GrolifantProcessForkOptions} to a Gradle 8.x {@link ProcessForkOptions}
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.3
 *
 * @deprecated Use {@link org.ysb33r.grolifant5.internal.core.SimpleGrolifantProcessForkOptions} instead.
 *   Will be removed in 6.0
 */
@CompileStatic
@Deprecated
class ProcessForkOptionsProxy implements GrolifantProcessForkOptions {

    ProcessForkOptionsProxy(ProcessForkOptions pfo) {
        this.pfo = pfo
    }

    @Override
    GrolifantProcessForkOptions executable(Object var1) {
        pfo.executable(var1)
        (GrolifantProcessForkOptions)this
    }

    @Override
    GrolifantProcessForkOptions workingDir(Object var1) {
        pfo.workingDir(var1)
        (GrolifantProcessForkOptions)this
    }

    @Override
    GrolifantProcessForkOptions environment(Map<String, ?> var1) {
        pfo.environment(var1)
        (GrolifantProcessForkOptions)this
    }

    @Override
    GrolifantProcessForkOptions environment(String var1, Object var2) {
        pfo.environment(var1, var2)
        (GrolifantProcessForkOptions)this
    }

    @Override
    GrolifantProcessForkOptions copyTo(ProcessForkOptions var1) {
        pfo.copyTo(var1)
        (GrolifantProcessForkOptions)this
    }

    @Override
    String getExecutable() {
        pfo.executable
    }

    @Override
    void setExecutable(String var1) {
        pfo.executable = var1
    }

    @Override
    void setExecutable(Object var1) {
        pfo.executable = var1
    }

    @Override
    File getWorkingDir() {
        pfo.workingDir
    }

    @Override
    void setWorkingDir(File var1) {
        pfo.workingDir = var1
    }

    @Override
    void setWorkingDir(Object var1) {
        pfo.workingDir = var1
    }

    @Override
    Map<String, Object> getEnvironment() {
       pfo.environment
    }

    @Override
    void setEnvironment(Map<String, ?> var1) {
        pfo.environment = var1
    }

    private final ProcessForkOptions pfo
}
