/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.loadable.v8

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.ysb33r.grolifant5.api.core.GrolifantProblemReporter
import org.ysb33r.grolifant5.internal.v8.services.GrolifantProblemReporterPre811
import org.ysb33r.grolifant5.internal.v8.services.GrolifantProblemReporterPre813
import org.ysb33r.grolifant5.internal.v8.services.GrolifantProblemReporterPre90

import javax.inject.Inject

import static org.ysb33r.grolifant5.api.core.LegacyLevel.PRE_8_13
import static org.ysb33r.grolifant5.internal.core.services.LegacyWarningReporterService.USE_LEGACY_WARNING_REPORTER

/**
 * Implementation for the problem reporter for Gradle 8.x
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.4
 */
@CompileStatic
class DefaultGrolifantProblemReporter implements GrolifantProblemReporter {

    @Inject
    DefaultGrolifantProblemReporter(Project project) {
        if (USE_LEGACY_WARNING_REPORTER) {
            this.reporter = new GrolifantProblemReporterPre811(project)
        } else if (PRE_8_13) {
            this.reporter = new GrolifantProblemReporterPre813(project)
        } else {
            this.reporter = new GrolifantProblemReporterPre90(project)
        }
    }

    @Delegate
    private final GrolifantProblemReporter reporter
}
