/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.loadable.v9

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.Transformer
import org.gradle.api.file.Directory
import org.gradle.api.file.ProjectLayout
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant5.loadable.core.ProjectOperationsProxy

import javax.inject.Inject

import static org.ysb33r.grolifant5.loadable.core.LoadableVersion.V9

/**
 * Implementation of {@link org.ysb33r.grolifant5.api.core.ConfigurationPhaseOperations} for Gradle 9.
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.3
 */
@CompileStatic
class DefaultProjectOperations extends ProjectOperationsProxy {

    @Inject
    DefaultProjectOperations(
        Project tempProjectReference,
        ProjectLayout layout
    ) {
        super(tempProjectReference, V9)

        this.buildDir = layout.buildDirectory.map({ Directory it ->
            it.asFile
        } as Transformer<File, Directory>)
    }

    /**
     * Provider for the build directory.
     *
     * @return Build directory.
     */
    @Override
    Provider<File> getBuildDir() {
        this.buildDir
    }

    private final Provider<File> buildDir
}
