/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.loadable.v9

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant5.loadable.core.LoadableVersion
import org.ysb33r.grolifant5.loadable.core.ProjectToolsProxy

import javax.inject.Inject

/**
 * Implementation of {@link org.ysb33r.grolifant5.api.core.ProjectTools} for Gradle 9.x.
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.3
 */
@CompileStatic
class DefaultProjectTools extends ProjectToolsProxy {

    @Inject
    DefaultProjectTools(Project project) {
        super(
            project,
            LoadableVersion.V9
        )
        this.projectGroup = propertyByName(project, 'group').orElse(UNSPECIFIED_PROJECT_GROUP)
    }

    /**
     * Lazy-evaluated project group.
     *
     * @return provider to project group
     */
    @Override
    Provider<String> getGroupProvider() {
        this.projectGroup
    }

    static private Provider<String> propertyByName(Project project, String name) {
        project.providers.gradleProperty(name)
    }

    private final Provider<String> projectGroup
}
