/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.internal.v9.jvm

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.process.CommandLineArgumentProvider
import org.gradle.process.JavaForkOptions
import org.ysb33r.grolifant5.internal.core.jvm.AbstractBaseGrolifantSimpleJavaForkOptions

import javax.inject.Inject

/**
 * Implementation of {@link org.ysb33r.grolifant5.api.core.jvm.GrolifantSimpleJavaForkOptions} for Gradle 9.
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.4
 */
@CompileStatic
class DefaultGrolifantSimpleJavaForkOptions extends AbstractBaseGrolifantSimpleJavaForkOptions {

    @Inject
    DefaultGrolifantSimpleJavaForkOptions(Project project) {
        super(project)
    }

    /**
     * Copies settings to {@link JavaForkOptions}.
     *
     * <p>Only copies options that were set. Empty providers are ignored.</p>
     *
     * @param target JavaForkOptions.
     */
    @Override
    void copyTo(JavaForkOptions target) {
        if (javaExec.present) {
            target.executable(javaExec.get().asFile)
        }
        if (sysProps.present) {
            target.jvmArgumentProviders.add({ ->
                sysProps.get().collect { k, v ->
                    if (v) {
                        "-D${k}=${v}".toString()
                    } else {
                        "-D${k}=".toString()
                    }
                } as Iterable<String>
            } as CommandLineArgumentProvider)
        }
        if (env.present) {
            target.environment(env.get())
        }
        if (jvmArguments.present) {
            target.jvmArgumentProviders.add({ ->
                jvmArguments.get()
            } as CommandLineArgumentProvider)
        }
        if (maxHeap.present) {
            target.maxHeapSize = maxHeap.get()
        }
        if (minHeap.present) {
            target.minHeapSize = minHeap.get()
        }
    }
}
