/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.plugins

import groovy.transform.CompileStatic
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.UnknownDomainObjectException
import org.ysb33r.grolifant5.api.core.ProjectOperations
import org.ysb33r.grolifant5.internal.core.loaders.ProjectOperationsLoader

/**
 * Adds an extension and a service both called {@code grolifant}.
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.0
 */
@CompileStatic
class GrolifantServicePlugin implements Plugin<Project> {

    public static final String SERVICE_NAME = 'grolifant'
    public static final String EXTENSION_NAME = SERVICE_NAME

    @Override
    void apply(Project project) {
        createGrolifantExtension(project)
    }

    private void createGrolifantExtension(Project project) {
        try {
            ProjectOperations.find(project)
        } catch (UnknownDomainObjectException e) {
            ProjectOperations po = ProjectOperationsLoader.load(project)
            project.extensions.add(ProjectOperations, GrolifantServicePlugin.EXTENSION_NAME, po)
        }
    }
}
