/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.downloader;

import java.io.File;
import java.nio.file.Path;

/**
 * Interface for downloading an executable by version and returning the location.
 *
 * @author Schalk W. Cronjé
 *
 * @since 1.1
 */
public interface ExecutableDownloader {
    /**
     * Locates, and optionally downloads, an executable by version.
     *
     * @param version version to download.
     *
     * @return Location of executable.
     */
    File getByVersion(String version);

    /**
     * Locates, and optionally downloads, an executable by version.
     *
     * @param version version to download.
     *
     * @return Location of executable.
     */
    default Path getPathByVersion(String version) {
        return getByVersion(version).toPath();
    }
}
