/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core.repositories;

import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.ysb33r.grolifant5.api.core.ProjectOperations;
import org.ysb33r.grolifant5.api.core.repositories.AuthenticationSupportedRepositoryContent;
import org.ysb33r.grolifant5.api.core.repositories.SimplePasswordCredentials;

public class AbstractAuthenticationSupportedRepository
implements ArtifactRepository,
AuthenticationSupported,
AuthenticationSupportedRepositoryContent {
    private String name;
    private Credentials repCredentials;
    private final AuthenticationContainer authentications;

    protected AbstractAuthenticationSupportedRepository(ProjectOperations po) {
        this.authentications = po.getRepositoryTools().authenticationContainer();
    }

    public PasswordCredentials getCredentials() {
        return this.getIfPasswordCredentials();
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        PasswordCredentials pw = this.getIfPasswordCredentials();
        action.execute((Object)pw);
    }

    public <T extends Credentials> T getCredentials(Class<T> aClass) {
        if (this.repCredentials == null) {
            try {
                this.repCredentials = (Credentials)aClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate " + String.valueOf(aClass), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Access failure for " + String.valueOf(aClass), e);
            }
        }
        try {
            return (T)((Credentials)aClass.cast(this.repCredentials));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Current credentials are not of type " + String.valueOf(aClass), e);
        }
    }

    public void credentials(Class<? extends Credentials> aClass) {
        try {
            this.repCredentials = aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot set credentials for" + String.valueOf(aClass), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot set credentials for" + String.valueOf(aClass), e);
        }
    }

    public <T extends Credentials> void credentials(Class<T> aClass, Action<? super T> action) {
        action.execute(this.getCredentials(aClass));
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        action.execute((Object)this.authentications);
    }

    public AuthenticationContainer getAuthentication() {
        return this.authentications;
    }

    public boolean hasCredentials() {
        return this.repCredentials != null;
    }

    @Override
    public void content(Action action) {
    }

    private void initCredentialsIfNull() {
        if (this.repCredentials == null) {
            this.repCredentials = new SimplePasswordCredentials();
        }
    }

    private PasswordCredentials getIfPasswordCredentials() {
        this.initCredentialsIfNull();
        if (this.repCredentials instanceof PasswordCredentials) {
            return (PasswordCredentials)this.repCredentials;
        }
        throw new IllegalArgumentException("Current credentials do not implemented PasswordCredentials");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

