/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core.runnable;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkerExecutor;
import org.ysb33r.grolifant5.api.core.CmdlineArgumentSpec;
import org.ysb33r.grolifant5.api.core.executable.ProcessExecutionSpec;
import org.ysb33r.grolifant5.api.core.jvm.ExecutionMode;
import org.ysb33r.grolifant5.api.core.jvm.JavaForkOptionsWithEnvProvider;
import org.ysb33r.grolifant5.api.core.jvm.JvmEntryPoint;
import org.ysb33r.grolifant5.api.core.jvm.worker.WorkerAppParameterFactory;
import org.ysb33r.grolifant5.api.core.jvm.worker.WorkerPromise;
import org.ysb33r.grolifant5.api.core.runnable.AbstractJvmExecSpec;
import org.ysb33r.grolifant5.api.core.runnable.ExecOutput;
import org.ysb33r.grolifant5.api.core.runnable.ForkedJvmExecutable;
import org.ysb33r.grolifant5.api.core.runnable.GrolifantDefaultTask;
import org.ysb33r.grolifant5.api.core.runnable.JvmExecutionModel;
import org.ysb33r.grolifant5.api.errors.UnsupportedConfigurationException;
import org.ysb33r.grolifant5.api.remote.worker.SerializableWorkerAppParameters;
import org.ysb33r.grolifant5.api.remote.worker.WorkerAppExecutorFactory;

public abstract class AbstractJvmModelExecTask<T extends AbstractJvmExecSpec, P extends SerializableWorkerAppParameters>
extends GrolifantDefaultTask
implements ForkedJvmExecutable<T>,
JvmExecutionModel {
    private T execSpec;
    private ExecutionMode execMode = ExecutionMode.JAVA_EXEC;
    private Boolean awaitMode = false;
    private final WorkerExecutor workerExecutor;
    private final Map<ExecutionMode, String> illegalExecutionModes;

    @Override
    public void setExecutionMode(ExecutionMode em) {
        if (this.illegalExecutionModes.containsKey((Object)em)) {
            throw new UnsupportedConfigurationException(em.name() + " cannot be used because: " + this.illegalExecutionModes.get((Object)em));
        }
        this.execMode = em;
    }

    @Override
    public void setAwaitMode(Boolean mode) {
        this.awaitMode = mode;
    }

    @Override
    public T jvm(Action<JavaForkOptionsWithEnvProvider> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).jvm((Action)configurator);
    }

    @Override
    public T jvm(@DelegatesTo(value=JavaForkOptionsWithEnvProvider.class) Closure<?> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).jvm((Closure)configurator);
    }

    @Override
    public T runnerSpec(Action<CmdlineArgumentSpec> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).runnerSpec((Action)configurator);
    }

    @Override
    public T runnerSpec(@DelegatesTo(value=CmdlineArgumentSpec.class) Closure<?> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).runnerSpec((Closure)configurator);
    }

    @Override
    public T entrypoint(Action<JvmEntryPoint> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).entrypoint((Action)configurator);
    }

    @Override
    public T entrypoint(@DelegatesTo(value=JvmEntryPoint.class) Closure<?> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).entrypoint((Closure)configurator);
    }

    @Override
    public T process(Action<ProcessExecutionSpec> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).process((Action)configurator);
    }

    @Override
    public T process(@DelegatesTo(value=ProcessExecutionSpec.class) Closure<?> configurator) {
        return (T)((AbstractJvmExecSpec)this.getJvmExecSpec()).process((Closure)configurator);
    }

    protected AbstractJvmModelExecTask(@Nullable WorkerExecutor we) {
        this.workerExecutor = we;
        this.illegalExecutionModes = new TreeMap<ExecutionMode, String>();
    }

    protected abstract WorkerAppExecutorFactory<P> createExecutorFactory();

    protected abstract WorkerAppParameterFactory<P> createParameterFactory();

    @Nested
    protected T getJvmExecSpec() {
        return this.execSpec;
    }

    protected void setExecSpec(T execSpec) {
        this.execSpec = execSpec;
    }

    protected void preventExecutionMode(ExecutionMode mode, String reason) {
        this.illegalExecutionModes.put(mode, reason);
    }

    @TaskAction
    protected void exec() {
        if (this.execMode.equals((Object)ExecutionMode.JAVA_EXEC) || this.workerExecutor == null) {
            ExecOutput result = this.execTools().javaexec((Action<? super JavaExecSpec>)((Action)x -> ((AbstractJvmExecSpec)this.getJvmExecSpec()).copyTo((JavaExecSpec)x)));
            this.processOutput(result);
            result.assertNormalExitValue();
        } else {
            WorkerPromise promise = ((AbstractJvmExecSpec)this.getJvmExecSpec()).submitToWorkQueue(this.execMode.workerIsolation(), this.workerExecutor, this.createExecutorFactory(), this.createParameterFactory());
            if (this.awaitMode.equals(true)) {
                promise.await();
            }
        }
    }

    protected void processOutput(ExecOutput output) {
        ((AbstractJvmExecSpec)this.execSpec).processOutput(output);
    }
}

