/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2024
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.jvm;

import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.process.JavaExecSpec;

/**
 * Defined the classpath for a JVM operation.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
public interface ClasspathSpec {
    /**
     * Add paths to the execution classpath.
     *
     * @param args Anything resolvable to {@code File} or {@code Path} intsances.
     */
    JavaExecSpec classpath(Object... args);

    /**
     * Get classpath as a {@link FileCollection}.
     *
     * @return Classpath.
     */
    @Classpath
    FileCollection getClasspath();

    /**
     * Replace existing classpath with a new collection of files.
     *
     * @param files New file collection.
     */
    JavaExecSpec setClasspath(FileCollection files);
}
