/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core.downloader;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.grolifant5.api.core.CheckSumVerification;
import org.ysb33r.grolifant5.api.core.ConfigCacheSafeOperations;
import org.ysb33r.grolifant5.api.core.FileSystemOperations;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactDownloader;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactRootVerification;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactUnpacker;
import org.ysb33r.grolifant5.api.core.downloader.DistributionInstaller;
import org.ysb33r.grolifant5.api.core.downloader.Downloader;
import org.ysb33r.grolifant5.api.core.downloader.UnpackParameters;
import org.ysb33r.grolifant5.api.errors.ChecksumFailedException;
import org.ysb33r.grolifant5.api.errors.DistributionFailedException;
import org.ysb33r.grolifant5.spi.unpackers.GrolifantUnpacker;

public abstract class AbstractDistributionInstaller
implements DistributionInstaller,
GroovyObject {
    public static final boolean IS_WINDOWS;
    public static final boolean IS_MACOSX;
    private ArtifactRootVerification artifactRootVerification;
    private ArtifactUnpacker artifactUnpacker;
    protected final ConfigCacheSafeOperations configCacheSafeOperations;
    protected final String distributionName;
    private String sdkManCandidateName;
    private String checksum;
    private Object downloadRoot;
    private final List<String> execPatterns;
    private final String basePath;
    private final Downloader downloadWorker;
    private final Provider<File> tmpDir;
    private final Map<String, UnpackParameters> defaultUnpackerParameters;
    private static final Pattern COMPRESSED_TAR;
    private static final Pattern SINGLE_EXTENSION;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    protected AbstractDistributionInstaller(String distributionName, String basePath, ConfigCacheSafeOperations taskComponents) {
        Map map;
        ArtifactUnpacker artifactUnpacker;
        ArtifactRootVerification artifactRootVerification;
        Downloader downloader;
        String string;
        ConfigCacheSafeOperations configCacheSafeOperations;
        String string2;
        MetaClass metaClass;
        List list;
        this.execPatterns = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.distributionName = string2 = distributionName;
        this.configCacheSafeOperations = configCacheSafeOperations = taskComponents;
        this.basePath = string = basePath;
        this.downloadWorker = downloader = taskComponents.execTools().downloader(distributionName);
        this.artifactRootVerification = artifactRootVerification = (ArtifactRootVerification)ScriptBytecodeAdapter.asType((Object)new _closure1(this, this).curry(this), ArtifactRootVerification.class);
        this.artifactUnpacker = artifactUnpacker = (ArtifactUnpacker)ScriptBytecodeAdapter.asType((Object)new _closure2(this, this).curry(this), ArtifactUnpacker.class);
        Provider<File> provider = taskComponents.fsOperations().buildDirDescendant(new GStringImpl(new Object[]{this.getClass().getName()}, new String[]{"tmp/", ""}));
        this.tmpDir = provider;
        this.defaultUnpackerParameters = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"msi", new UnpackParameters(taskComponents), "dmg", new UnpackParameters(taskComponents)});
        if (IS_WINDOWS) {
            ((UnpackParameters)DefaultGroovyMethods.getAt(this.defaultUnpackerParameters, (Object)"msi")).environment(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"TMP", taskComponents.providerTools().environmentVariable("TMP"), "TEMP", taskComponents.providerTools().environmentVariable("TEMP")}));
        }
        if (IS_MACOSX) {
            String string3 = basePath;
            ((UnpackParameters)DefaultGroovyMethods.getAt(this.defaultUnpackerParameters, (Object)"dmg")).setBaseRelativePath(string3);
        }
    }

    @Override
    public void setSdkManCandidateName(String sdkCandidateName) {
        String string;
        this.sdkManCandidateName = string = sdkCandidateName;
    }

    @Override
    public String getSdkManCandidateName() {
        return this.sdkManCandidateName;
    }

    @Override
    public void addExecPattern(String ... relPaths) {
        this.execPatterns.addAll(DefaultGroovyMethods.toList((Object[])relPaths));
    }

    @Override
    public void setChecksum(String cs) {
        String string;
        if (cs.length() != 64 || !ScriptBytecodeAdapter.matchRegex((Object)cs, (Object)"[\\p{Digit}\\p{Alpha}]{64}")) {
            throw (Throwable)new IllegalArgumentException("Not a valid SHA-256 checksum");
        }
        this.checksum = string = cs.toLowerCase();
    }

    @Override
    public Provider<File> getDistributionRoot(String version) {
        Reference version2 = new Reference((Object)version);
        return this.configCacheSafeOperations.providerTools().provider(new Callable<File>(this, version2){
            public /* synthetic */ Reference version;
            final /* synthetic */ AbstractDistributionInstaller this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                AbstractDistributionInstaller abstractDistributionInstaller;
                this.this$0 = abstractDistributionInstaller = p0;
                this.version = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public File call() throws Exception {
                return this.this$0.resolveDistributionLocationForVersion(ShortTypeHandling.castToString((Object)this.version.get()));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        });
    }

    @Override
    public void setDownloadRoot(Object downloadRootDir) {
        Object object;
        this.downloadRoot = object = downloadRootDir;
    }

    @Override
    public Provider<File> getDistributionFile(String version, String fileRelPath) {
        Reference fileRelPath2 = new Reference((Object)fileRelPath);
        public final class _getDistributionFile_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fileRelPath;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDistributionFile_closure3(Object _outerInstance, Object _thisObject, Reference fileRelPath) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fileRelPath = reference = fileRelPath;
            }

            public File doCall(File file) {
                return new File(file, ShortTypeHandling.castToString((Object)this.fileRelPath.get()));
            }

            @Generated
            public File call(File file) {
                return this.doCall(file);
            }

            @Generated
            public String getFileRelPath() {
                return ShortTypeHandling.castToString((Object)this.fileRelPath.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDistributionFile_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.getDistributionRoot(version).map((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _getDistributionFile_closure3(this, this, fileRelPath2)), Transformer.class));
    }

    protected File resolveDistributionLocationForVersion(String version) {
        File file;
        File location = this.locateDistributionInCustomLocation(version);
        if (location == null && DefaultTypeTransformation.booleanUnbox((Object)this.sdkManCandidateName)) {
            location = this.getDistFromSdkMan(version);
        }
        return DefaultTypeTransformation.booleanUnbox((Object)(file = location)) ? file : this.getDistFromCache(version);
    }

    protected File getDistFromSdkMan(String version) {
        File sdkCandidate = new File(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.getProperty("user.home"), this.sdkManCandidateName, version}, new String[]{"", "/.sdkman/", "/", ""})));
        return (File)ScriptBytecodeAdapter.castToType((Object)(sdkCandidate.exists() && sdkCandidate.isDirectory() ? sdkCandidate : null), File.class);
    }

    protected File getDistFromCache(String version) {
        URI distUri = this.uriFromVersion(version);
        File root = DefaultTypeTransformation.booleanUnbox((Object)this.downloadRoot) ? this.configCacheSafeOperations.fsOperations().file(this.downloadRoot) : (File)ScriptBytecodeAdapter.castToType((Object)this.configCacheSafeOperations.fsOperations().getGradleUserHomeDir().get(), File.class);
        CheckSumVerification chk = (CheckSumVerification)ScriptBytecodeAdapter.castToType(DefaultTypeTransformation.booleanUnbox((Object)this.checksum) ? this.getCheckSumVerificationInstance(this.configCacheSafeOperations.stringTools().safeUri(distUri).toString()) : null, CheckSumVerification.class);
        ArtifactDownloader artifactDownloader = new ArtifactDownloader(distUri, root, this.configCacheSafeOperations, this.basePath, this.artifactRootVerification, this.artifactUnpacker, chk);
        return artifactDownloader.getFromCache(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.distributionName, version}, new String[]{"", ":", ""})), DefaultTypeTransformation.booleanUnbox((Object)this.configCacheSafeOperations.projectTools().getOfflineProvider().get()), this.downloadWorker);
    }

    protected File verifyDistributionRoot(File distDir) {
        List<File> dirs = this.listDirs(distDir);
        if (dirs.isEmpty()) {
            throw (Throwable)((Object)new DistributionFailedException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.distributionName}, new String[]{"", " "}).plus("does not contain any directories. Expected to find exactly 1 directory."))));
        }
        if (dirs.size() != 1) {
            throw (Throwable)((Object)new DistributionFailedException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.distributionName}, new String[]{"", "  contains too many directories. "}).plus("Expected to find exactly 1 directory."))));
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(dirs, (int)0), File.class);
    }

    protected void verifyDownloadChecksum(String sourceUrl, File localCompressedFile, String expectedSum) {
        if (expectedSum != null) {
            String actualSum = this.calculateSha256Sum(localCompressedFile);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.checksum, (Object)actualSum)) {
                localCompressedFile.delete();
                throw (Throwable)new ChecksumFailedException(this.distributionName, sourceUrl, localCompressedFile, expectedSum, actualSum);
            }
        }
    }

    protected List<File> listDirs(File distDir) {
        return this.configCacheSafeOperations.fsOperations().listDirs(distDir);
    }

    protected void unpack(File srcArchive, File destDir) {
        Reference destDir2 = new Reference((Object)destDir);
        Reference archiveTree = new Reference((Object)this.compressedTree(srcArchive));
        Reference patterns = new Reference(this.execPatterns);
        public final class _unpack_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _unpack_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(FileCopyDetails fcd) {
                if (!fcd.isDirectory()) {
                    int n = fcd.getMode() | 0x49;
                    fcd.setMode(n);
                    return n;
                }
                return (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
            }

            @Generated
            public Integer call(FileCopyDetails fcd) {
                return this.doCall(fcd);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unpack_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference setExecMode = new Reference((Object)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _unpack_closure4(this, this)), Action.class)));
        public final class _unpack_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference archiveTree;
            private /* synthetic */ Reference destDir;
            private /* synthetic */ Reference patterns;
            private /* synthetic */ Reference setExecMode;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _unpack_closure5(Object _outerInstance, Object _thisObject, Reference archiveTree, Reference destDir, Reference patterns, Reference setExecMode) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.archiveTree = reference4 = archiveTree;
                this.destDir = reference3 = destDir;
                this.patterns = reference2 = patterns;
                this.setExecMode = reference = setExecMode;
            }

            public CopySpec doCall(CopySpec cs) {
                public final class _closure8
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference archiveTree;
                    private /* synthetic */ Reference destDir;
                    private /* synthetic */ Reference patterns;
                    private /* synthetic */ Reference setExecMode;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure8(Object _outerInstance, Object _thisObject, Reference archiveTree, Reference destDir, Reference patterns, Reference setExecMode) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.archiveTree = reference4 = archiveTree;
                        this.destDir = reference3 = destDir;
                        this.patterns = reference2 = patterns;
                        this.setExecMode = reference = setExecMode;
                    }

                    public CopySpec doCall(Object it) {
                        ((CopySpec)this.getDelegate()).from(new Object[]{(FileTree)ScriptBytecodeAdapter.castToType((Object)this.archiveTree.get(), FileTree.class)});
                        ((CopySpec)this.getDelegate()).into((Object)((File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class)));
                        if (!DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.getField(_closure8.class, AbstractDistributionInstaller.class, (String)"IS_WINDOWS")) && !((List)ScriptBytecodeAdapter.castToType((Object)this.patterns.get(), List.class)).isEmpty()) {
                            return ((CopySpec)this.getDelegate()).filesMatching((Iterable)((List)ScriptBytecodeAdapter.castToType((Object)this.patterns.get(), List.class)), (Action)ScriptBytecodeAdapter.castToType((Object)this.setExecMode.get(), Action.class));
                        }
                        return (CopySpec)ScriptBytecodeAdapter.castToType(null, CopySpec.class);
                    }

                    @Generated
                    public FileTree getArchiveTree() {
                        return (FileTree)ScriptBytecodeAdapter.castToType((Object)this.archiveTree.get(), FileTree.class);
                    }

                    @Generated
                    public File getDestDir() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class);
                    }

                    @Generated
                    public List getPatterns() {
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.patterns.get(), List.class);
                    }

                    @Generated
                    public Action getSetExecMode() {
                        return (Action)ScriptBytecodeAdapter.castToType((Object)this.setExecMode.get(), Action.class);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public CopySpec doCall() {
                        CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_closure8.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure8.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return (CopySpec)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)cs, (Closure)new _closure8((Object)this, this.getThisObject(), this.archiveTree, this.destDir, this.patterns, this.setExecMode)), CopySpec.class);
            }

            @Generated
            public CopySpec call(CopySpec cs) {
                return this.doCall(cs);
            }

            @Generated
            public FileTree getArchiveTree() {
                return (FileTree)ScriptBytecodeAdapter.castToType((Object)this.archiveTree.get(), FileTree.class);
            }

            @Generated
            public File getDestDir() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.destDir.get(), File.class);
            }

            @Generated
            public List getPatterns() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.patterns.get(), List.class);
            }

            @Generated
            public Action getSetExecMode() {
                return (Action)ScriptBytecodeAdapter.castToType((Object)this.setExecMode.get(), Action.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unpack_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.configCacheSafeOperations.fsOperations().copy((Action<? super CopySpec>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _unpack_closure5(this, this, archiveTree, destDir2, patterns, setExecMode)), Action.class)));
    }

    @Nullable
    protected GrolifantUnpacker.Parameters unpackParametersForExtension(String extension) {
        return (GrolifantUnpacker.Parameters)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.defaultUnpackerParameters, (Object)extension.toLowerCase(Locale.US)), GrolifantUnpacker.Parameters.class);
    }

    protected String extractFinalExtension(String filename) {
        return this.extractExtension(filename, SINGLE_EXTENSION);
    }

    private String calculateSha256Sum(File file) {
        public final class _calculateSha256Sum_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateSha256Sum_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(InputStream content) {
                Reference digest = new Reference((Object)MessageDigest.getInstance("SHA-256"));
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference digest;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference digest) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.digest = reference = digest;
                    }

                    public Object doCall(Object bytes, Object len) {
                        ((MessageDigest)ScriptBytecodeAdapter.castToType((Object)this.digest.get(), MessageDigest.class)).update((byte[])ScriptBytecodeAdapter.castToType((Object)bytes, byte[].class), 0, DefaultTypeTransformation.intUnbox((Object)len));
                        return null;
                    }

                    @Generated
                    public Object call(Object bytes, Object len) {
                        return this.doCall(bytes, len);
                    }

                    @Generated
                    public MessageDigest getDigest() {
                        return (MessageDigest)ScriptBytecodeAdapter.castToType((Object)this.digest.get(), MessageDigest.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                IOGroovyMethods.eachByte((InputStream)content, (int)4096, (Closure)new _closure9((Object)this, this.getThisObject(), digest));
                return EncodingGroovyMethods.encodeHex((byte[])((MessageDigest)digest.get()).digest()).toString();
            }

            @Generated
            public String call(InputStream content) {
                return this.doCall(content);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateSha256Sum_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ShortTypeHandling.castToString((Object)ResourceGroovyMethods.withInputStream((File)file, (Closure)new _calculateSha256Sum_closure6(this, this)));
    }

    private FileTree compressedTree(File srcArchive) {
        FileSystemOperations fs = this.configCacheSafeOperations.fsOperations();
        String name = srcArchive.getName().toLowerCase();
        if (name.endsWith(".zip")) {
            return fs.zipTree(srcArchive);
        }
        if (name.endsWith(".tar")) {
            return fs.tarTree(srcArchive);
        }
        if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
            return fs.tarTree(fs.gzipResource(srcArchive));
        }
        if (name.endsWith(".tar.bz2") || name.endsWith(".tbz")) {
            return fs.tarTree(fs.bzip2Resource(srcArchive));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)name, (Object)COMPRESSED_TAR))) {
            String ext = this.extractExtension(name, COMPRESSED_TAR);
            File uncompressed = this.unpackArchiveByOtherExtension(srcArchive, ext);
            return fs.tarTree(uncompressed);
        }
        String ext = this.extractFinalExtension(name);
        File unpacked = this.unpackArchiveByOtherExtension(srcArchive, ext);
        return fs.fileTree(unpacked);
    }

    private File unpackArchiveByOtherExtension(File srcArchive, String ext) {
        Reference ext2 = new Reference((Object)ext);
        public final class _unpackArchiveByOtherExtension_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _unpackArchiveByOtherExtension_closure7(Object _outerInstance, Object _thisObject, Reference ext) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.ext = reference = ext;
            }

            public Boolean doCall(GrolifantUnpacker it) {
                return it.supportExtension(ShortTypeHandling.castToString((Object)this.ext.get()));
            }

            @Generated
            public Boolean call(GrolifantUnpacker it) {
                return this.doCall(it);
            }

            @Generated
            public String getExt() {
                return ShortTypeHandling.castToString((Object)this.ext.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _unpackArchiveByOtherExtension_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GrolifantUnpacker unpacker = (GrolifantUnpacker)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(ServiceLoader.load(GrolifantUnpacker.class), (Closure)new _unpackArchiveByOtherExtension_closure7(this, this, ext2)), GrolifantUnpacker.class);
        if (unpacker != null) {
            GrolifantUnpacker.Parameters params = this.unpackParametersForExtension((String)ext2.get());
            GrolifantUnpacker.Engine engine = params == null ? unpacker.create(this.configCacheSafeOperations) : unpacker.create(this.configCacheSafeOperations, params);
            File workDir = (File)ScriptBytecodeAdapter.castToType((Object)this.tmpDir.get(), File.class);
            workDir.mkdirs();
            File uncompressedFileDir = File.createTempFile(StringGroovyMethods.replaceAll((CharSequence)srcArchive.getName(), (Pattern)((Pattern)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.bitwiseNegate((Object)new GStringImpl(new Object[]{(String)ext2.get()}, new String[]{"\\.", "$"})), Pattern.class)), (CharSequence)""), "$$$", workDir);
            uncompressedFileDir.deleteOnExit();
            engine.unpack(srcArchive, uncompressedFileDir);
            return uncompressedFileDir;
        }
        this.notSupported((String)ext2.get());
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    private void notSupported(String ext) {
        throw (Throwable)((Object)new DistributionFailedException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ext, ext}, new String[]{"Could not unpack file with extension '", "'. This might be due to grolifant5-unpacker-", ""}).plus("not being on the classpath or that the specific archive/compression format is not supported."))));
    }

    private CheckSumVerification getCheckSumVerificationInstance(String textUri) {
        Reference textUri2 = new Reference((Object)textUri);
        Reference chk = new Reference((Object)this.checksum);
        return new CheckSumVerification(this, textUri2, chk){
            public /* synthetic */ Reference chk;
            public /* synthetic */ Reference textUri;
            final /* synthetic */ AbstractDistributionInstaller this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                AbstractDistributionInstaller abstractDistributionInstaller;
                this.this$0 = abstractDistributionInstaller = p0;
                this.textUri = reference2 = p1;
                this.chk = reference = p2;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void verify(File downloadedTarget) {
                this.this$0.verifyDownloadChecksum(ShortTypeHandling.castToString((Object)this.textUri.get()), downloadedTarget, ShortTypeHandling.castToString((Object)this.chk.get()));
            }

            @Override
            public String getChecksum() {
                return ShortTypeHandling.castToString((Object)this.chk.get());
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(2.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(2.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, AbstractDistributionInstaller.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
    }

    private String extractExtension(String filename, Pattern filePattern) {
        CallSite[] callSiteArray = AbstractDistributionInstaller.$getCallSiteArray();
        Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)filename, (Object)filePattern);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)matcher))) {
            throw (Throwable)callSiteArray[1].callConstructor(DistributionFailedException.class, (Object)new GStringImpl(new Object[]{filename, filePattern}, new String[]{"Cannot extract extension from '", "' using '", "'"}));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[2].call(callSiteArray[3].call((Object)matcher, (Object)0), (Object)1));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractDistributionInstaller.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractDistributionInstaller.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractDistributionInstaller.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractDistributionInstaller.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AbstractDistributionInstaller.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractDistributionInstaller.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        boolean bl;
        boolean bl2;
        IS_WINDOWS = bl2 = OperatingSystem.current().isWindows();
        IS_MACOSX = bl = OperatingSystem.current().isMacOsX();
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)".+\\.tar\\.(\\w+)$");
        COMPRESSED_TAR = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)".+\\.(\\w+)$");
        SINGLE_EXTENSION = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        log = logger = LoggerFactory.getLogger((String)"org.ysb33r.grolifant5.api.core.downloader.AbstractDistributionInstaller");
    }

    @Generated
    public ArtifactRootVerification getArtifactRootVerification() {
        return this.artifactRootVerification;
    }

    @Override
    @Generated
    public void setArtifactRootVerification(ArtifactRootVerification artifactRootVerification) {
        this.artifactRootVerification = artifactRootVerification;
    }

    @Generated
    public ArtifactUnpacker getArtifactUnpacker() {
        return this.artifactUnpacker;
    }

    @Override
    @Generated
    public void setArtifactUnpacker(ArtifactUnpacker artifactUnpacker) {
        this.artifactUnpacker = artifactUnpacker;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "matches";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "getAt";
        stringArray[3] = "getAt";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        AbstractDistributionInstaller.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractDistributionInstaller.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractDistributionInstaller.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public File doCall(AbstractDistributionInstaller abi, File distDir) {
            return (File)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)abi, (String)"verifyDistributionRoot", (Object)new Object[]{distDir}), File.class);
        }

        @Generated
        public File call(AbstractDistributionInstaller abi, File distDir) {
            return this.doCall(abi, distDir);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(AbstractDistributionInstaller abi, File src, File dest) {
            return InvokerHelper.invokeMethodSafe((Object)abi, (String)"unpack", (Object)new Object[]{src, dest});
        }

        @Generated
        public Object call(AbstractDistributionInstaller abi, File src, File dest) {
            return this.doCall(abi, src, dest);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

