/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.loadable.core;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.TextResource;
import org.ysb33r.grolifant5.api.core.StringTools;
import org.ysb33r.grolifant5.api.errors.ChecksumCreationException;
import org.ysb33r.grolifant5.internal.core.Resources;
import org.ysb33r.grolifant5.internal.core.Transform;

public abstract class StringToolsProxy
implements StringTools,
GroovyObject {
    private final ProviderFactory providers;
    private static final Closure URI_TRANSFORMER;
    private static final Function<Object, String> STRING_TRANSFORMER;
    private static final Function<Object, String> STRING_TRANSFORMER_NULL;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected StringToolsProxy(ProviderFactory pf) {
        ProviderFactory providerFactory;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.providers = providerFactory = pf;
    }

    @Override
    public String hashUri(URI uri) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA256");
        messageDigest.update(uri.toString().getBytes());
        String string = new BigInteger(1, messageDigest.digest()).toString(36);
        try {
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new ChecksumCreationException("Could not create SHA-256 checksum of URI", e);
        }
    }

    @Override
    public String loadTextFromResource(String resourcePath) {
        return Resources.loadTextFromResource(resourcePath);
    }

    @Override
    public Provider<String> provideTextFromResource(String resourcePath) {
        Reference resourcePath2 = new Reference((Object)resourcePath);
        public final class _provideTextFromResource_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourcePath;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideTextFromResource_closure1(Object _outerInstance, Object _thisObject, Reference resourcePath) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.resourcePath = reference = resourcePath;
            }

            public String doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).loadTextFromResource(ShortTypeHandling.castToString((Object)this.resourcePath.get()));
            }

            @Generated
            public String getResourcePath() {
                return ShortTypeHandling.castToString((Object)this.resourcePath.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideTextFromResource_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideTextFromResource_closure1(this, this, resourcePath2)));
    }

    @Override
    public String packageNameFromUri(URI uri) {
        String path = uri.getPath();
        int p = path.lastIndexOf("/");
        return p < 0 ? path : path.substring(p + 1);
    }

    @Override
    public Provider<String> provideString(Object stringy) {
        Reference stringy2 = new Reference(stringy);
        public final class _provideString_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stringy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideString_closure2(Object _outerInstance, Object _thisObject, Reference stringy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.stringy = reference = stringy;
            }

            public String doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringize(this.stringy.get());
            }

            @Generated
            public Object getStringy() {
                return this.stringy.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideString_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideString_closure2(this, this, stringy2)));
    }

    @Override
    public Provider<String> provideStringOrNull(Object stringy) {
        Reference stringy2 = new Reference(stringy);
        public final class _provideStringOrNull_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stringy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideStringOrNull_closure3(Object _outerInstance, Object _thisObject, Reference stringy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.stringy = reference = stringy;
            }

            public String doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringizeOrNull(this.stringy.get());
            }

            @Generated
            public Object getStringy() {
                return this.stringy.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideStringOrNull_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideStringOrNull_closure3(this, this, stringy2)));
    }

    public Provider<Map<String, String>> provideValues(Map<String, ? extends Object> props) {
        Reference props2 = new Reference(props);
        public final class _provideValues_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference props;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideValues_closure4(Object _outerInstance, Object _thisObject, Reference props) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.props = reference = props;
            }

            public Map<String, String> doCall() {
                return ((StringTools)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringTools.class)).stringizeValues((Map)ScriptBytecodeAdapter.castToType((Object)this.props.get(), Map.class));
            }

            @Generated
            public Map getProps() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.props.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideValues_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideValues_closure4(this, this, props2)));
    }

    public Provider<Map<String, String>> provideValues(Provider<Map<String, ?>> props) {
        public final class _provideValues_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _provideValues_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Provider<Map<String, String>> doCall(Object it) {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).provideValues((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Provider<Map<String, String>> doCall() {
                CallSite[] callSiteArray = _provideValues_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideValues_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_provideValues_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _provideValues_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return props.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _provideValues_closure5(this, this)), Transformer.class));
    }

    @Override
    public Provider<Map<String, String>> provideValuesDropNull(Provider<Map<String, Object>> props) {
        public final class _provideValuesDropNull_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _provideValuesDropNull_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Provider<Map<String, String>> doCall(Object it) {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).provideValuesDropNull((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Provider<Map<String, String>> doCall() {
                CallSite[] callSiteArray = _provideValuesDropNull_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideValuesDropNull_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_provideValuesDropNull_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _provideValuesDropNull_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return props.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _provideValuesDropNull_closure6(this, this)), Transformer.class));
    }

    @Override
    public Provider<Map<String, String>> provideValuesDropNull(Map<String, ?> props) {
        Reference props2 = new Reference(props);
        public final class _provideValuesDropNull_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference props;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideValuesDropNull_closure7(Object _outerInstance, Object _thisObject, Reference props) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.props = reference = props;
            }

            public Map<String, String> doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringizeValuesDropNull((Map)ScriptBytecodeAdapter.castToType((Object)this.props.get(), Map.class));
            }

            @Generated
            public Map getProps() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.props.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideValuesDropNull_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideValuesDropNull_closure7(this, this, props2)));
    }

    @Override
    public Provider<URI> provideUri(Object uriThingy) {
        Reference uriThingy2 = new Reference(uriThingy);
        public final class _provideUri_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference uriThingy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _provideUri_closure8(Object _outerInstance, Object _thisObject, Reference uriThingy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.uriThingy = reference = uriThingy;
            }

            public URI doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).urize(this.uriThingy.get());
            }

            @Generated
            public Object getUriThingy() {
                return this.uriThingy.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _provideUri_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.providers.provider((Callable)((Object)new _provideUri_closure8(this, this, uriThingy2)));
    }

    @Override
    public String stringize(Object stringy) {
        return ShortTypeHandling.castToString((Object)Transform.convertItem(stringy, STRING_TRANSFORMER));
    }

    @Override
    public String stringizeOrNull(Object stringy) {
        return ShortTypeHandling.castToString((Object)Transform.convertItemOrNull(stringy, STRING_TRANSFORMER_NULL));
    }

    @Override
    public List<String> stringize(Collection<?> stringyThings) {
        ArrayList output = (ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), ArrayList.class);
        Transform.convertItems(stringyThings, output, STRING_TRANSFORMER);
        return output;
    }

    @Override
    public List<String> stringizeDropNull(Collection<?> stringyThings) {
        ArrayList output = (ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), ArrayList.class);
        Transform.convertItemsDropNull(stringyThings, output, STRING_TRANSFORMER_NULL);
        return output;
    }

    @Override
    public Map<String, String> stringizeValuesDropNull(Map<String, ?> props) {
        public final class _stringizeValuesDropNull_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _stringizeValuesDropNull_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<String> doCall(Object k, Object v) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringizeOrNull(v)});
            }

            @Generated
            public List<String> call(Object k, Object v) {
                return this.doCall(k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _stringizeValuesDropNull_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _stringizeValuesDropNull_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _stringizeValuesDropNull_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ((Map.Entry)it).getValue() != null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _stringizeValuesDropNull_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _stringizeValuesDropNull_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_stringizeValuesDropNull_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _stringizeValuesDropNull_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return DefaultGroovyMethods.findAll((Map)DefaultGroovyMethods.collectEntries(props, (Closure)new _stringizeValuesDropNull_closure9(this, this)), (Closure)new _stringizeValuesDropNull_closure10(this, this));
    }

    @Override
    public URI safeUri(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    @Override
    public void updateStringProperty(Property<String> provider, Object stringy) {
        Reference stringy2 = new Reference(stringy);
        public final class _updateStringProperty_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference stringy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateStringProperty_closure11(Object _outerInstance, Object _thisObject, Reference stringy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.stringy = reference = stringy;
            }

            public String doCall() {
                return ((StringToolsProxy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), StringToolsProxy.class)).stringizeOrNull(this.stringy.get());
            }

            @Generated
            public Object getStringy() {
                return this.stringy.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateStringProperty_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        provider.set(this.providers.provider((Callable)((Object)new _updateStringProperty_closure11(this, this, stringy2))));
    }

    @Override
    public URI urize(Object uriThingy) {
        return (URI)ScriptBytecodeAdapter.castToType(Transform.convertItem(uriThingy, (Function)ScriptBytecodeAdapter.castToType((Object)URI_TRANSFORMER.curry((Object)this), Function.class)), URI.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StringToolsProxy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ Function<Object, String> pfaccess$0(StringToolsProxy $that) {
        return (Function)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(StringToolsProxy.class, StringToolsProxy.class, (String)"STRING_TRANSFORMER"), Function.class);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Function function;
        Function function2;
        public final class __clinit__closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public URI doCall(StringTools str, Object uri) {
                Object object = uri;
                if (ScriptBytecodeAdapter.isCase((Object)object, URI.class)) {
                    return (URI)ScriptBytecodeAdapter.castToType((Object)uri, URI.class);
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, URL.class)) {
                    return ((URL)ScriptBytecodeAdapter.castToType((Object)uri, URL.class)).toURI();
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, File.class)) {
                    return ((File)ScriptBytecodeAdapter.castToType((Object)uri, File.class)).toURI();
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, Path.class)) {
                    return ((Path)ScriptBytecodeAdapter.castToType((Object)uri, Path.class)).toUri();
                }
                return ResourceGroovyMethods.toURI((String)str.stringize(uri));
            }

            @Generated
            public URI call(StringTools str, Object uri) {
                return this.doCall(str, uri);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        __clinit__closure12 __clinit__closure122 = new __clinit__closure12(StringToolsProxy.class, StringToolsProxy.class);
        URI_TRANSFORMER = __clinit__closure122;
        public final class __clinit__closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object str) {
                Object object = str;
                if (ScriptBytecodeAdapter.isCase((Object)object, TextResource.class)) {
                    return ((TextResource)ScriptBytecodeAdapter.castToType((Object)str, TextResource.class)).asString();
                }
                return DefaultGroovyMethods.toString((Object)str);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STRING_TRANSFORMER = function2 = (Function)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure13(StringToolsProxy.class, StringToolsProxy.class)), Function.class);
        public final class __clinit__closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object str) {
                return ShortTypeHandling.castToString(str == null ? null : StringToolsProxy.pfaccess$0(null).apply(str));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        STRING_TRANSFORMER_NULL = function = (Function)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure14(StringToolsProxy.class, StringToolsProxy.class)), Function.class);
    }
}

