/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant5.api.errors.UnexpectedNullException;
import org.ysb33r.grolifant5.api.errors.UnsupportedConfigurationException;
import org.ysb33r.grolifant5.internal.core.IterableUtils;
import org.ysb33r.grolifant5.internal.core.property.gradle.GradleProviderSpecialUtilities;

public class Transform {
    public static <I, O> List<O> toList(Collection<I> collection, Function<I, O> tx) {
        return collection.stream().map(tx).collect(Collectors.toList());
    }

    public static <I, O> List<O> toList(Iterable<I> collection, Function<I, O> tx) {
        return IterableUtils.toList(collection).stream().map(tx).collect(Collectors.toList());
    }

    public static <I, O> Set<O> toSet(Collection<I> collection, Function<I, O> tx) {
        return collection.stream().map(tx).collect(Collectors.toSet());
    }

    public static <I, O> Set<O> toSet(Iterable<I> collection, Function<I, O> tx) {
        return IterableUtils.toList(collection).stream().map(tx).collect(Collectors.toSet());
    }

    public static <OUT> OUT convertItem(Object input, Function<Object, OUT> transformer) {
        return Transform.convertItemImpl(input, transformer, false);
    }

    public static <OUT> OUT convertItemOrNull(Object input, Function<Object, OUT> transformer) {
        return Transform.convertItemImpl(input, transformer, true);
    }

    public static <OUT> Collection<OUT> convertItems(Collection<?> inputs, Collection<OUT> target, Function<Object, OUT> transformer) {
        Transform.convertItemsImpl(inputs, transformer, target, false);
        return target;
    }

    public static <OUT> Collection<OUT> convertItemsDropNull(Collection<?> inputs, Collection<OUT> target, Function<Object, OUT> transformer) {
        Transform.convertItemsImpl(inputs, transformer, target, true);
        return target;
    }

    private static <OUT> OUT convertItemImpl(Object input, Function<Object, OUT> transformer, boolean allowNull) {
        try {
            if (input == null) {
                if (allowNull) {
                    return null;
                }
                throw new UnexpectedNullException("Unexpected null value encountered");
            }
            if (input instanceof Provider) {
                return Transform.convertItemImpl(Transform.unwindProvider((Provider)input, allowNull), transformer, allowNull);
            }
            if (input instanceof Optional) {
                return Transform.convertItemImpl(Transform.unwindOptional((Optional)input, allowNull), transformer, allowNull);
            }
            if (input instanceof Supplier) {
                return Transform.convertItemImpl(((Supplier)input).get(), transformer, allowNull);
            }
            if (input instanceof Callable) {
                return Transform.convertItemImpl(((Callable)input).call(), transformer, allowNull);
            }
            if (input instanceof Collection) {
                throw new UnsupportedConfigurationException("Collections are not allowed");
            }
            return transformer.apply(input);
        }
        catch (UnexpectedNullException e) {
            throw e;
        }
        catch (UnsupportedConfigurationException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            if (allowNull) {
                return null;
            }
            throw new UnexpectedNullException("Unexpected empty value encountered", e);
        }
        catch (NoSuchElementException e) {
            if (allowNull) {
                return null;
            }
            throw new UnexpectedNullException("Unexpected empty value encountered", e);
        }
        catch (GradleException e) {
            throw new UnsupportedConfigurationException("Item cannot be resolved", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new UnsupportedConfigurationException("Unexpected exception when trying to convert item of type " + input.getClass().getCanonicalName(), e);
        }
    }

    private static <OUT> void convertItemsImpl(Collection<?> inputs, Function<Object, OUT> transformer, Collection<OUT> collection, boolean dropNull) {
        inputs.forEach(item -> {
            Optional<Collection<?>> potentialList = GradleProviderSpecialUtilities.valuesForMultipleValueProvider(item);
            if (potentialList.isPresent()) {
                Transform.convertItemsImpl(potentialList.get(), transformer, collection, dropNull);
            } else if (item instanceof Map) {
                Transform.convertItemsImpl(((Map)item).values(), transformer, collection, dropNull);
            } else if (item instanceof Collection) {
                Transform.convertItemsImpl((Collection)item, transformer, collection, dropNull);
            } else if (item instanceof Provider) {
                Transform.resolveSingleItemOrIterableTo(Transform.unwindProvider((Provider)item, dropNull), transformer, collection, dropNull);
            } else if (item instanceof Optional) {
                Transform.resolveSingleItemOrIterableTo(Transform.unwindOptional((Optional)item, dropNull), transformer, collection, dropNull);
            } else if (item instanceof Supplier) {
                Transform.resolveSingleItemOrIterableTo(((Supplier)item).get(), transformer, collection, dropNull);
            } else if (item instanceof Callable) {
                try {
                    Transform.resolveSingleItemOrIterableTo(((Callable)item).call(), transformer, collection, dropNull);
                }
                catch (Exception e) {
                    throw new UnsupportedConfigurationException("Unexpected exception when trying to convert item of type " + item.getClass().getCanonicalName(), e);
                }
            } else {
                Transform.resolveSingleItemOrIterableTo(item, transformer, collection, dropNull);
            }
        });
    }

    private static <OUT> void resolveSingleItemOrIterableTo(Object item, Function<Object, OUT> transformer, Collection<OUT> collection, boolean dropNull) {
        if (item instanceof Collection) {
            Transform.convertItemsImpl((Collection)item, transformer, collection, dropNull);
        } else if (IterableUtils.treatAsIterable(item)) {
            Transform.convertItemsImpl(IterableUtils.toList((Iterable)item), transformer, collection, dropNull);
        } else {
            OUT value = Transform.convertItemImpl(item, transformer, dropNull);
            if (value != null) {
                collection.add(value);
            }
        }
    }

    private static Object unwindProvider(Provider<?> item, boolean allowNull) {
        if (allowNull) {
            return item.getOrNull();
        }
        return item.get();
    }

    private static Object unwindOptional(Optional<?> item, boolean allowNull) {
        if (allowNull) {
            return item.orElse(null);
        }
        return item.get();
    }
}

