/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core;

import java.io.File;
import java.util.List;
import org.ysb33r.grolifant5.internal.core.os.OperatingSystemUtils;

public interface OperatingSystem {
    public boolean isWindows();

    public boolean isMacOsX();

    public boolean isLinux();

    public boolean isFreeBSD();

    public boolean isNetBSD();

    public boolean isSolaris();

    public boolean isUnix();

    public String getPathSeparator();

    public String toString();

    public File findInPath(String var1);

    public List<File> getPath();

    public List<File> findAllInPath(String var1);

    public List<String> getExecutableNames(String var1);

    public Arch getArch();

    public String getArchStr();

    public String getSharedLibrarySuffix();

    public String getStaticLibrarySuffix();

    public String getSharedLibraryName(String var1);

    public String getStaticLibraryName(String var1);

    public static OperatingSystem current() {
        return OperatingSystemUtils.CURRENT;
    }

    public String getName();

    public String getVersion();

    public String getPathVar();

    public String getHomeVar();

    public static enum Arch {
        X86_64("amd64"),
        X86("i386"),
        POWERPC("ppc"),
        SPARC("sparc"),
        ARM64("aarch64"),
        ARM32("arm_32"),
        S390_32("s390_32"),
        S390_64("s390_64"),
        UNKNOWN("(unknown)");

        private final String id;

        private Arch(String id) {
            this.id = id;
        }
    }
}

