/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core.downloader;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.grolifant5.api.core.CheckSumVerification;
import org.ysb33r.grolifant5.api.core.ConfigCacheSafeOperations;
import org.ysb33r.grolifant5.api.core.ExclusiveFileAccess;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactRequiresDownload;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactRootVerification;
import org.ysb33r.grolifant5.api.core.downloader.ArtifactUnpacker;
import org.ysb33r.grolifant5.api.core.downloader.DownloadedLocalFile;
import org.ysb33r.grolifant5.api.core.downloader.Downloader;
import org.ysb33r.grolifant5.api.errors.DistributionFailedException;

public class ArtifactDownloader
implements GroovyObject {
    private static final ArtifactRequiresDownload DOWNLOAD_IF_NOT_EXISTS;
    private final ExclusiveFileAccess exclusiveFileAccessManager;
    private final URI downloadURI;
    private final File downloadRoot;
    private final File projectDir;
    private final String basePath;
    private final CheckSumVerification verifyDownloadChecksum;
    private final ArtifactUnpacker unpacker;
    private final ArtifactRootVerification verifyArtifactRoot;
    private final ArtifactRequiresDownload requiresDownload;
    private final ConfigCacheSafeOperations configCacheSafeOperations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ArtifactDownloader(URI downloadURI, File downloadRoot, ConfigCacheSafeOperations po, String basePath, ArtifactRootVerification verifyArtifactRoot, ArtifactUnpacker unpacker, CheckSumVerification verifyDownloadChecksum) {
        ConfigCacheSafeOperations configCacheSafeOperations;
        File file;
        ArtifactRequiresDownload artifactRequiresDownload;
        ArtifactUnpacker artifactUnpacker;
        ArtifactRootVerification artifactRootVerification;
        CheckSumVerification checkSumVerification;
        String string;
        File file2;
        URI uRI;
        MetaClass metaClass;
        ExclusiveFileAccess exclusiveFileAccess;
        this.exclusiveFileAccessManager = exclusiveFileAccess = new ExclusiveFileAccess(120000, 200);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.downloadURI = uRI = downloadURI;
        this.downloadRoot = file2 = downloadRoot;
        this.basePath = string = basePath;
        this.verifyDownloadChecksum = checkSumVerification = verifyDownloadChecksum;
        this.verifyArtifactRoot = artifactRootVerification = verifyArtifactRoot;
        this.unpacker = artifactUnpacker = unpacker;
        this.requiresDownload = artifactRequiresDownload = DOWNLOAD_IF_NOT_EXISTS;
        this.projectDir = file = po.fsOperations().getProjectDir();
        this.configCacheSafeOperations = configCacheSafeOperations = po;
    }

    public ArtifactDownloader(URI downloadURI, File downloadRoot, ConfigCacheSafeOperations po, String basePath, ArtifactRequiresDownload requiresDownload, CheckSumVerification verifyDownloadChecksum) {
        ConfigCacheSafeOperations configCacheSafeOperations;
        File file;
        ArtifactRequiresDownload artifactRequiresDownload;
        CheckSumVerification checkSumVerification;
        String string;
        File file2;
        URI uRI;
        MetaClass metaClass;
        ExclusiveFileAccess exclusiveFileAccess;
        this.exclusiveFileAccessManager = exclusiveFileAccess = new ExclusiveFileAccess(120000, 200);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.downloadURI = uRI = downloadURI;
        this.downloadRoot = file2 = downloadRoot;
        this.basePath = string = basePath;
        this.verifyDownloadChecksum = checkSumVerification = verifyDownloadChecksum;
        this.requiresDownload = artifactRequiresDownload = requiresDownload;
        this.projectDir = file = po.fsOperations().getProjectDir();
        this.configCacheSafeOperations = configCacheSafeOperations = po;
    }

    public File getFromCache(String description, boolean offlineMode, Downloader downloadInstance) {
        DownloadedLocalFile downloadDetails = downloadInstance.downloadLocation(this.downloadURI, this.downloadRoot, this.basePath);
        DownloadAction downloadAction = new DownloadAction();
        boolean bl = offlineMode;
        downloadAction.setOfflineMode(bl);
        String string = description;
        downloadAction.setDescription(string);
        DownloadedLocalFile downloadedLocalFile = downloadDetails;
        downloadAction.setLocalFile(downloadedLocalFile);
        URI uRI = this.downloadURI;
        downloadAction.setDownloadURI(uRI);
        ArtifactRootVerification artifactRootVerification = this.verifyArtifactRoot;
        downloadAction.setVerifyArtifactRoot(artifactRootVerification);
        ArtifactRequiresDownload artifactRequiresDownload = this.requiresDownload;
        downloadAction.setRequiresDownload(artifactRequiresDownload);
        Downloader downloader = downloadInstance;
        downloadAction.setDownloadInstance(downloader);
        CheckSumVerification checkSumVerification = this.verifyDownloadChecksum;
        downloadAction.setVerifyDownloadChecksum(checkSumVerification);
        ArtifactUnpacker artifactUnpacker = this.unpacker;
        downloadAction.setUnpacker(artifactUnpacker);
        ConfigCacheSafeOperations configCacheSafeOperations = this.configCacheSafeOperations;
        downloadAction.setPo(configCacheSafeOperations);
        DownloadAction downloadAction2 = downloadAction;
        return (File)ScriptBytecodeAdapter.castToType((Object)this.exclusiveFileAccessManager.access(downloadDetails.getDownloadedFile(), downloadAction2), File.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ArtifactDownloader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        ArtifactRequiresDownload artifactRequiresDownload;
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(URI d, File f) {
                return !f.isFile();
            }

            @Generated
            public Boolean call(URI d, File f) {
                return this.doCall(d, f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DOWNLOAD_IF_NOT_EXISTS = artifactRequiresDownload = (ArtifactRequiresDownload)ScriptBytecodeAdapter.asType((Object)((Object)new __clinit__closure1(ArtifactDownloader.class, ArtifactDownloader.class)), ArtifactRequiresDownload.class);
        log = logger = LoggerFactory.getLogger((String)"org.ysb33r.grolifant5.api.core.downloader.ArtifactDownloader");
    }

    private static class DownloadAction
    implements Callable<File>,
    GroovyObject {
        private boolean offlineMode;
        private String description;
        private DownloadedLocalFile localFile;
        private URI downloadURI;
        private ArtifactRootVerification verifyArtifactRoot;
        private ArtifactRequiresDownload requiresDownload;
        private Downloader downloadInstance;
        private CheckSumVerification verifyDownloadChecksum;
        private ArtifactUnpacker unpacker;
        private ConfigCacheSafeOperations po;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public DownloadAction() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public File call() throws Exception {
            URI distributionUrl = this.localFile.getDistributionUrl();
            if (this.localFile.getDistributionDir().isDirectory() && this.localFile.getMarkerFile().isFile()) {
                return (File)ScriptBytecodeAdapter.castToType(this.verifyArtifactRoot.apply(this.localFile.getDistributionDir()), File.class);
            }
            if (this.requiresDownload.download(this.downloadURI, this.localFile.getDownloadedFile())) {
                if (this.offlineMode && ScriptBytecodeAdapter.compareNotEqual((Object)distributionUrl.getScheme(), (Object)"file")) {
                    throw (Throwable)((Object)new DistributionFailedException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.description}, new String[]{"Cannot download ", " as currently offline"}))));
                }
                File tmpDownloadedFile = new File(this.localFile.getDownloadedFile().getParentFile(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localFile.getDownloadedFile().getName()}, new String[]{"", ".part"})));
                tmpDownloadedFile.delete();
                this.downloadInstance.logProgress(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.po.stringTools().safeUri(distributionUrl)}, new String[]{"Downloading ", ""})));
                this.downloadInstance.download(distributionUrl, tmpDownloadedFile);
                tmpDownloadedFile.renameTo(this.localFile.getDownloadedFile());
            }
            List<File> topLevelDirs = this.po.fsOperations().listDirs(this.localFile.getDistributionDir());
            List<File> list = topLevelDirs;
            Iterator<File> iterator = list != null ? list.iterator() : null;
            File dir = null;
            Iterator<File> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), File.class);
                    this.downloadInstance.logProgress(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir.getAbsolutePath()}, new String[]{"Deleting directory ", ""})));
                    ResourceGroovyMethods.deleteDir((File)dir);
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.verifyDownloadChecksum)) {
                this.verifyDownloadChecksum.verify(this.localFile.getDownloadedFile());
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.unpacker)) {
                this.downloadInstance.logProgress(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localFile.getDownloadedFile().getAbsolutePath(), this.localFile.getDistributionDir().getAbsolutePath()}, new String[]{"Unpacking ", " to ", ""})));
                this.unpacker.accept(this.localFile.getDownloadedFile(), this.localFile.getDistributionDir());
            }
            File root = DefaultTypeTransformation.booleanUnbox((Object)this.verifyArtifactRoot) ? (File)ScriptBytecodeAdapter.castToType(this.verifyArtifactRoot.apply(this.localFile.getDistributionDir()), File.class) : this.localFile.getDistributionDir();
            this.localFile.getMarkerFile().createNewFile();
            return root;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DownloadAction.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public boolean getOfflineMode() {
            return this.offlineMode;
        }

        @Generated
        public boolean isOfflineMode() {
            return this.offlineMode;
        }

        @Generated
        public void setOfflineMode(boolean bl) {
            this.offlineMode = bl;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setDescription(String string) {
            this.description = string;
        }

        @Generated
        public DownloadedLocalFile getLocalFile() {
            return this.localFile;
        }

        @Generated
        public void setLocalFile(DownloadedLocalFile downloadedLocalFile) {
            this.localFile = downloadedLocalFile;
        }

        @Generated
        public URI getDownloadURI() {
            return this.downloadURI;
        }

        @Generated
        public void setDownloadURI(URI uRI) {
            this.downloadURI = uRI;
        }

        @Generated
        public ArtifactRootVerification getVerifyArtifactRoot() {
            return this.verifyArtifactRoot;
        }

        @Generated
        public void setVerifyArtifactRoot(ArtifactRootVerification artifactRootVerification) {
            this.verifyArtifactRoot = artifactRootVerification;
        }

        @Generated
        public ArtifactRequiresDownload getRequiresDownload() {
            return this.requiresDownload;
        }

        @Generated
        public void setRequiresDownload(ArtifactRequiresDownload artifactRequiresDownload) {
            this.requiresDownload = artifactRequiresDownload;
        }

        @Generated
        public Downloader getDownloadInstance() {
            return this.downloadInstance;
        }

        @Generated
        public void setDownloadInstance(Downloader downloader) {
            this.downloadInstance = downloader;
        }

        @Generated
        public CheckSumVerification getVerifyDownloadChecksum() {
            return this.verifyDownloadChecksum;
        }

        @Generated
        public void setVerifyDownloadChecksum(CheckSumVerification checkSumVerification) {
            this.verifyDownloadChecksum = checkSumVerification;
        }

        @Generated
        public ArtifactUnpacker getUnpacker() {
            return this.unpacker;
        }

        @Generated
        public void setUnpacker(ArtifactUnpacker artifactUnpacker) {
            this.unpacker = artifactUnpacker;
        }

        @Generated
        public ConfigCacheSafeOperations getPo() {
            return this.po;
        }

        @Generated
        public void setPo(ConfigCacheSafeOperations configCacheSafeOperations) {
            this.po = configCacheSafeOperations;
        }
    }
}

