/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.internal.core.jvm;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.file.FileCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ysb33r.grolifant5.api.core.ClassLocation;
import org.ysb33r.grolifant5.api.errors.ClassLocationException;
import org.ysb33r.grolifant5.internal.core.jvm.ClassLocationImpl;

public class ClassPathUtils
implements GroovyObject {
    public static final String SLASH;
    public static final String DOT;
    public static final String JAR = "jar";
    public static final String JRT = "jrt";
    public static final String CLASS_EXT = ".class";
    public static final Pattern SCHEME_REGEX;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ClassPathUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static ClassLocation resolveClassLocationSimple(Class aClass) {
        Class clazz = aClass;
        ProtectionDomain protectionDomain = clazz != null ? clazz.getProtectionDomain() : null;
        CodeSource codeSource = protectionDomain != null ? protectionDomain.getCodeSource() : null;
        String location = ShortTypeHandling.castToString((Object)(codeSource != null ? codeSource.getLocation() : null));
        if (DefaultTypeTransformation.booleanUnbox((Object)location)) {
            return new ClassLocationImpl(new File(ResourceGroovyMethods.toURI((String)location)).getAbsoluteFile());
        }
        URL uRL = aClass.getResource(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)SLASH, (CharSequence)aClass.getCanonicalName().replace(DOT, SLASH)), (CharSequence)CLASS_EXT));
        URI uri = uRL != null ? uRL.toURI() : null;
        if (uri == null) {
            throw (Throwable)new ClassLocationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{aClass.getName()}, new String[]{"Location for ", " cannot be located."})));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)JAR)) {
            return new ClassLocationImpl(new File(new URI(StringGroovyMethods.replaceAll((CharSequence)uri.getRawSchemeSpecificPart(), (Pattern)SCHEME_REGEX, (CharSequence)""))).getAbsoluteFile());
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)JRT)) {
            return new ClassLocationImpl(uri.toURL());
        }
        return new ClassLocationImpl(new File(uri).getParentFile().getAbsoluteFile());
    }

    public static ClassLocation resolveClassLocationWithSubstitution(Class aClass, FileCollection substitutionSearch, Pattern substitutionMatch, Pattern redoIfMatch, Pattern ignoreFromPaths) {
        Reference substitutionMatch2 = new Reference((Object)substitutionMatch);
        Reference ignoreFromPaths2 = new Reference((Object)ignoreFromPaths);
        ClassLocation entryPointClasspath = ClassPathUtils.resolveClassLocationSimple(aClass);
        if (DefaultTypeTransformation.booleanUnbox((Object)entryPointClasspath.getFile())) {
            Object v3;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{aClass.getCanonicalName(), entryPointClasspath.getFile()}, new String[]{"Resolved ", " to ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            String canonicalPath = entryPointClasspath.getFile().getCanonicalPath();
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)canonicalPath, (Object)redoIfMatch))) {
                Object v2;
                Object v1;
                public final class _resolveClassLocationWithSubstitution_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference substitutionMatch;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _resolveClassLocationWithSubstitution_closure1(Object _outerInstance, Object _thisObject, Reference substitutionMatch) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.substitutionMatch = reference = substitutionMatch;
                    }

                    public Matcher doCall(File it) {
                        return (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)it.getName(), (Object)((Pattern)ScriptBytecodeAdapter.castToType((Object)this.substitutionMatch.get(), Pattern.class))), Matcher.class);
                    }

                    @Generated
                    public Matcher call(File it) {
                        return this.doCall(it);
                    }

                    @Generated
                    public Pattern getSubstitutionMatch() {
                        return (Pattern)ScriptBytecodeAdapter.castToType((Object)this.substitutionMatch.get(), Pattern.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _resolveClassLocationWithSubstitution_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Set candidates = DefaultGroovyMethods.findAll((Set)substitutionSearch.getFiles(), (Closure)new _resolveClassLocationWithSubstitution_closure1(ClassPathUtils.class, ClassPathUtils.class, substitutionMatch2));
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{candidates.size(), candidates}, new String[]{"Found ", " potential candidate(s): ", ""})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                public final class _resolveClassLocationWithSubstitution_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ignoreFromPaths;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _resolveClassLocationWithSubstitution_closure2(Object _outerInstance, Object _thisObject, Reference ignoreFromPaths) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.ignoreFromPaths = reference = ignoreFromPaths;
                    }

                    public Boolean doCall(Object it) {
                        return !DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.findRegex((Object)((File)it).getCanonicalPath(), (Object)((Pattern)ScriptBytecodeAdapter.castToType((Object)this.ignoreFromPaths.get(), Pattern.class))));
                    }

                    @Generated
                    public Pattern getIgnoreFromPaths() {
                        return (Pattern)ScriptBytecodeAdapter.castToType((Object)this.ignoreFromPaths.get(), Pattern.class);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        CallSite[] callSiteArray = _resolveClassLocationWithSubstitution_closure2.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _resolveClassLocationWithSubstitution_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_resolveClassLocationWithSubstitution_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _resolveClassLocationWithSubstitution_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Set replacements = DefaultGroovyMethods.findAll((Set)candidates, (Closure)new _resolveClassLocationWithSubstitution_closure2(ClassPathUtils.class, ClassPathUtils.class, ignoreFromPaths2));
                if (replacements.isEmpty()) {
                    throw (Throwable)new ClassLocationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{aClass.getCanonicalName()}, new String[]{"Cannot find suitable jar replacement for ", ""})));
                }
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.getAt((Iterable)replacements, (int)0), replacements}, new String[]{"Selected ", " from ", ""})));
                    v2 = null;
                } else {
                    v2 = null;
                }
                return new ClassLocationImpl((File)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)replacements, (int)0), File.class));
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{canonicalPath, redoIfMatch}, new String[]{"Ignoring: ", " does not match ", ""})));
                v3 = null;
            } else {
                v3 = null;
            }
            return entryPointClasspath;
        }
        return entryPointClasspath;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ClassPathUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        String string;
        String string2;
        DOT = string2 = ".";
        SLASH = string = "/";
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"(!.+?)$");
        SCHEME_REGEX = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        log = logger = LoggerFactory.getLogger((String)"org.ysb33r.grolifant5.internal.core.jvm.ClassPathUtils");
    }
}

