/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.tasks.WorkResult;
import org.ysb33r.grolifant5.api.core.ClosureUtils;

public interface FileSystemOperations {
    public Provider<File> buildDirDescendant(Object var1);

    public ReadableResource bzip2Resource(Object var1);

    public ReadableResource gzipResource(Object var1);

    public WorkResult copy(Action<? super CopySpec> var1);

    public CopySpec copySpec();

    default public CopySpec copySpec(Action<? super CopySpec> action) {
        CopySpec cs = this.copySpec();
        action.execute((Object)cs);
        return cs;
    }

    default public CopySpec copySpec(@DelegatesTo(value=CopySpec.class) Closure<?> action) {
        CopySpec cs = this.copySpec();
        ClosureUtils.configureItem(cs, action);
        return cs;
    }

    public void copyResourceToFile(String var1, File var2);

    public File createTempDirectory(String var1);

    public WorkResult delete(Action<? super DeleteSpec> var1);

    public ConfigurableFileCollection emptyFileCollection();

    public File file(Object var1);

    public File fileOrNull(Object var1);

    public ConfigurableFileCollection files(Collection<?> var1);

    public ConfigurableFileTree fileTree(Object var1);

    public ConfigurableFileCollection filesDropNull(Collection<?> var1);

    public Provider<File> getGradleHomeDir();

    public Provider<File> getGradleUserHomeDir();

    public File getProjectCacheDir();

    public File getProjectDir();

    public File getProjectRootDir();

    public List<File> listDirs(File var1);

    public Properties loadPropertiesFromResource(String var1);

    public Properties loadPropertiesFromResource(String var1, ClassLoader var2);

    public Provider<File> provideFile(Object var1);

    public Provider<File> provideProjectCacheDir();

    public Provider<File> provideProjectDir();

    public Provider<Properties> providePropertiesFromResource(String var1);

    public Provider<Properties> providePropertiesFromResource(String var1, ClassLoader var2);

    public Provider<File> provideRootDir();

    public Provider<File> provideProjectCacheDirDescendant(Object var1);

    public String relativePath(Object var1);

    default public String relativePathNotEmpty(Object f) {
        String path = this.relativePath(f);
        return path.isEmpty() ? "." : path;
    }

    public String relativeRootPath(Object var1);

    public String relativePathToProjectDir(Object var1);

    public String relativePathToRootDir(Object var1);

    public String relativize(File var1, File var2);

    public String relativize(Path var1, Path var2);

    public FileTree resolveFilesFromCopySpec(CopySpec var1);

    public WorkResult sync(Action<? super CopySpec> var1);

    public FileTree tarTree(Object var1);

    public String toSafeFileName(String var1);

    public Path toSafePath(String ... var1);

    default public File toSafeFile(String ... parts) {
        return this.toSafePath(parts).toFile();
    }

    public void updateFileProperty(Property<File> var1, Object var2);

    public FileTree zipTree(Object var1);
}

