/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core.runnable;

import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.ysb33r.grolifant5.api.core.ConfigCacheSafeOperations;
import org.ysb33r.grolifant5.api.core.executable.ExecutableEntryPoint;
import org.ysb33r.grolifant5.api.core.runnable.AbstractExecSpec;
import org.ysb33r.grolifant5.api.core.runnable.ExecOutput;
import org.ysb33r.grolifant5.api.core.runnable.GrolifantDefaultTask;

public abstract class AbstractExecWrapperTask<E extends AbstractExecSpec<E>>
extends GrolifantDefaultTask
implements ConfigCacheSafeOperations {
    public void setEnvironment(Map<String, ?> args) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.setEnvironment(args)));
    }

    public void addEnvironmentProvider(Provider<? extends Map<String, String>> provider) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.addEnvironmentProvider(provider)));
    }

    public void environment(Map<String, ?> args) {
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.environment(args)));
    }

    @TaskAction
    protected void exec() throws Exception {
        String exe = this.stringTools().stringize(this.getExecutableLocation().get());
        ((AbstractExecSpec)this.getExecSpec()).entrypoint((Action<ExecutableEntryPoint>)((Action)ep -> ep.executable(exe)));
        ExecOutput result = ((AbstractExecSpec)this.getExecSpec()).submitAsExec();
        result.assertNormalExitValue();
    }

    protected AbstractExecWrapperTask() {
    }

    @Internal
    protected abstract E getExecSpec();

    @Internal
    protected abstract Provider<File> getExecutableLocation();
}

