/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.git;

import org.gradle.api.Named;
import org.gradle.api.provider.Provider;

import java.net.URI;

/**
 * A description of a Git repository from a cloud provider
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
public interface CloudGitDescriptor extends Named {

    /**
     * Obtains the URI for the archive of the repository.
     *
     * @return Repo URI
     *
     * @deprecated
     */
    @Deprecated
    default URI getArchiveUri() {
        return getArchiveUriProvider().get();
    }

    /**
     * Obtains the URI for the archive of the repository.
     *
     * @return Repo URI
     *
     * @since 5.4
     */
    Provider<URI> getArchiveUriProvider();

    /**
     * Organisation on Git cloud service
     *
     * @return Organisation
     *
     * @deprecated
     */
    @Deprecated
    default String getOrganisation() {
        return getOrganisationProvider().get();
    }

    /**
     * Organisation on Git cloud service
     *
     * @return Organisation
     *
     * @since 5.4
     */
    Provider<String> getOrganisationProvider();


    /**
     * Repository on Git cloud service
     *
     * @return Repository
     *
     * @deprecated
     */
    @Deprecated
    default String getRepository() {
        return getRepositoryProvider().get();
    }

    /**
     * Repository on Git cloud service
     *
     * @return Repository
     *
     * @since 5.4
     */
    Provider<String> getRepositoryProvider();
}
