/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant5.api.core;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Locale;
import org.gradle.api.Action;

public interface GrolifantProblemReporter {
    public void report(ProblemId var1, Action<ProblemSpec> var2);

    public void report(ProblemId var1, @DelegatesTo(value=ProblemSpec.class) Closure<?> var2);

    public void report(String var1, String var2, ProblemGroup var3, Action<ProblemSpec> var4);

    default public void report(String problemName, String displayName, String pgName, String pgDisplay, Action<ProblemSpec> config) {
        this.report(problemName, displayName, ProblemGroup.of(pgName, pgDisplay), config);
    }

    public void report(String var1, String var2, ProblemGroup var3, @DelegatesTo(value=ProblemSpec.class) Closure<?> var4);

    default public void report(String problemName, String displayName, String pgName, String pgDisplay, @DelegatesTo(value=ProblemSpec.class) Closure<?> config) {
        this.report(problemName, displayName, ProblemGroup.of(pgName, pgDisplay), config);
    }

    public static interface ProblemSpec {
        public void setContextualLabel(String var1);

        public void setDetails(String var1);

        public void setDocumentedAt(String var1);

        public void setFileLocation(String var1);

        public void lineInFileLocation(String var1, int var2);

        public void lineInFileLocation(String var1, int var2, int var3);

        public void lineInFileLocation(String var1, int var2, int var3, int var4);

        public void offsetInFileLocation(String var1, int var2, int var3);

        public void setSeverity(Severity var1);

        default public void setSeverity(String severity) {
            this.setSeverity(Severity.valueOf(severity.toUpperCase(Locale.US)));
        }

        public void setSolution(String var1);

        public void stackLocation();

        public void withException(Throwable var1);
    }

    public static enum Severity {
        ADVICE,
        ERROR,
        WARNING;

    }

    public static class ProblemId {
        final String name;
        final String displayName;
        final ProblemGroup problemGroup;

        public ProblemGroup getProblemGroup() {
            return this.problemGroup;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public static ProblemId of(String name, String displayName, ProblemGroup problemGroup) {
            return new ProblemId(name, displayName, problemGroup);
        }

        public static ProblemId of(String name, String displayName, String groupName, String groupDisplayName) {
            return new ProblemId(name, displayName, groupName, groupDisplayName);
        }

        ProblemId(String name, String displayName, String groupName, String groupDisplayName) {
            this(name, displayName, ProblemGroup.of(groupName, groupDisplayName));
        }

        ProblemId(String name, String displayName, ProblemGroup problemGroup) {
            this.name = name;
            this.displayName = displayName;
            this.problemGroup = problemGroup;
        }
    }

    public static class ProblemGroup {
        final String name;
        final String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getName() {
            return this.name;
        }

        public static ProblemGroup of(String name, String displayName) {
            return new ProblemGroup(name, displayName);
        }

        ProblemGroup(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }
}

