/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.jvm;

import org.gradle.api.provider.Provider;
import org.gradle.process.JavaForkOptions;

/**
 * An extended interface that can be used to update a Gradlle API {@link JavaForkOptions}
 * @author Schalk W. Cronjé
 * @since 5.4
 */
public interface GrolifantSimpleJavaForkOptions extends GrolifantSimpleSetJavaForkOptions {
    /**
     * Copies settings to {@link JavaForkOptions}.
     *
     * <p>Only copies options that were set. Empty providers are ignored.</p>
     *
     * @param target JavaForkOptions.
     */
    void copyTo(JavaForkOptions target);

    /**
     * A signature that can be used as an input to a task such as {@link org.gradle.api.tasks.JavaExec} to help
     * with up-to-date checks.
     *
     * <p>Changes in system properties and jvm arguments are taken into account</p>
     *
     * @return Signature.
     */
    Provider<String> getSignature();
}
