/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.internal.core;

import groovy.lang.Closure;
import org.gradle.api.Project;
import org.ysb33r.grolifant5.api.core.ConfigCacheSafeOperations;
import org.ysb33r.grolifant5.api.core.ConfigurationPhaseOperations;
import org.ysb33r.grolifant5.api.core.GrolifantProblemReporter;
import org.ysb33r.grolifant5.api.core.ProjectOperations;

/**
 * Reports problems on the deprecated {@link ProjectOperations}.
 *
 * <p>
 * Will be removed in 6.0
 * </p>
 *
 * @author Schalk W. Cronjé
 * @since 5.5
 *
 * @deprecated Will be removed in 6.0
 */
@Deprecated
public class DeprecatedProjectOperationsReporter {
    public static final GrolifantProblemReporter.ProblemGroup PROBLEM_GROUP = GrolifantProblemReporter.ProblemGroup.of(
            "org.ysb33r.grolifant5.api.core.ProjectOperations",
            "Grolifant's ProjectOperations is deprecated"
    );
    public static final GrolifantProblemReporter.ProblemGroup PG_EXT = GrolifantProblemReporter.ProblemGroup.of(
            "grolifantOps Extension",
            "Deprecated option on grolifantOps extension"
    );
    public static final GrolifantProblemReporter.ProblemId PROBLEM_ID = GrolifantProblemReporter.ProblemId.of(
            "org.ysb33r.grolifant5.api.core.ProjectOperations",
            "Deprecated method destined to be removed in Grolifant 6.0",
            PROBLEM_GROUP
    );

    public static final GrolifantProblemReporter.ProblemId PROBLEM_ID_EXT = GrolifantProblemReporter.ProblemId.of(
            "grolifantOps Extension",
            "Deprecated method destined to be removed in Grolifant 6.0",
            PG_EXT
    );

    public static void report(Project project, String methodCalled, String replacementSolution) {
        report(ConfigurationPhaseOperations.from(project), methodCalled, replacementSolution);
    }

    public static void report(ConfigCacheSafeOperations cpo, final String methodCalled, final String replacementSolution) {
        cpo.problemReporter().report(PROBLEM_ID, spec -> {
                spec.setDetails(methodCalled);
                spec.setSolution(replacementSolution);
//            spec.documentedAt
            }
        );
    }

    public static void reportExt(ConfigCacheSafeOperations cpo, final String methodCalled, final String replacementSolution) {
        cpo.problemReporter().report(PROBLEM_ID_EXT, spec -> {
                spec.setDetails(methodCalled);
                spec.setSolution(replacementSolution + ". This is a method on grolifantOps extension, or ConfigurationPhaseOperations.");
//            spec.documentedAt
            }
        );
    }
}
