/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.internal.core

import groovy.transform.CompileStatic
import org.gradle.api.provider.ProviderFactory
import org.ysb33r.grolifant5.api.core.ConfigurationPhaseOperations
import org.ysb33r.grolifant5.api.core.ConfigurationTools
import org.ysb33r.grolifant5.api.core.RepositoryTools
import org.ysb33r.grolifant5.api.core.TaskTools
import org.ysb33r.grolifant5.api.errors.NotSupportedException

/**
 * Implementation of {@link ConfigurationPhaseOperations}.
 *
 * @author Schalk W. Cronjé
 *
 * @since 5.5
 */
@CompileStatic
class SimpleGrolifantConfigurationPhaseComponents extends SimpleGrolifantComponents
    implements ConfigurationPhaseOperations {

    SimpleGrolifantConfigurationPhaseComponents(ConfigurationPhaseOperations cpo) {
        super(cpo)
        this.ct = cpo.configurationTools()
        this.tt = cpo.taskTools()
        this.rt = cpo.repositoryTools()
    }

    @Override
    ConfigurationTools configurationTools() {
        this.ct
    }

    @Override
    TaskTools taskTools() {
        this.tt
    }

    @Override
    RepositoryTools repositoryTools() {
        this.rt
    }

    @Override
    @Deprecated
    ProviderFactory getProviders() {
       throw new NotSupportedException('getProviders() is not supported here. Use project.providers instead.')
    }

    private final ConfigurationTools ct
    private final TaskTools tt
    private final RepositoryTools rt
}
