/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core;

import java.io.File;
import java.util.Map;

/**
 * A workaround for {@link org.gradle.process.ProcessForkOptions} to keep compatibility across Gradle versions.
 *
 * @author Schalk W. Cronjé
 * @since 5.3
 */
public interface GrolifantProcessForkOptions {
    String getExecutable();

    void setExecutable(String var1);

    void setExecutable(Object var1);

    GrolifantProcessForkOptions executable(Object var1);

    File getWorkingDir();

    void setWorkingDir(File var1);

    void setWorkingDir(Object var1);

    GrolifantProcessForkOptions workingDir(Object var1);

    Map<String, Object> getEnvironment();

    void setEnvironment(Map<String, ?> var1);

    GrolifantProcessForkOptions environment(Map<String, ?> var1);

    GrolifantProcessForkOptions environment(String var1, Object var2);

    GrolifantProcessForkOptions copyTo(org.gradle.process.ProcessForkOptions var1);
}
