/**
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2025
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant5.api.core.runnable;

import org.gradle.process.ExecSpec;

/**
 * Additional operations that can be performed on something taht implemetns {@link Executable}.
 *
 * @author Schalk W. Cronjé
 * @since 5.0
 */
public interface ExecutableOperations {
    /**
     * Copies this specification to a standard {@link ExecSpec}.
     *
     * @param spec Target execution specification.
     */
    void copyTo(ExecSpec spec);
}
